<?php
if ( !$user['admin'] ) {
    exit;
}

$project  = $db->row("SELECT * FROM project WHERE id = ?", $pid);
$sheetId  = $project['sheetId'];
$comments = $db->run("SELECT * FROM comment WHERE sheetId = ? ORDER BY createdAt ASC", $sheetId);

//set up calendar events
$i      = 0;
$events = [];
foreach ( $comments as $comment ) {
    // create a $dt object with the UTC timezone
    $dt = new DateTime($comment['createdAt'], new DateTimeZone('UTC'));
            
    // change the timezone of the object without changing its time
    $dt->setTimezone(new DateTimeZone('America/New_York'));
    
    // format the datetime
    $date = $dt->format('Y-m-d H:i:s');
    // $date = $dt->format(DateTime::ATOM);

    $events[$i]['title']     = $comment['createdByName'];
    $events[$i]['start']     = $date;
    $events[$i]['commentId'] = $comment['id'];

    $i++;
}


