<?php
    if ( !$user['superAdmin'] ) {
        exit;
    }

    if ( $publicProjectId = $_POST['id'] ) {
        $publicProject = $db->row("SELECT * FROM public_project WHERE id = ?", $publicProjectId);
        $attachments = $db->run("SELECT * FROM public_project_attachment WHERE publicProjectId = ? ORDER BY sort ASC", $publicProject['id']);
        $projects = $db->run("SELECT * FROM project");
    } else {
        exit;
    }

    if ( $publicProject ) :
?>
    <div class="form-floating mb-2">
        <input type="text" name="title" class="form-control" id="editPublicProjectTitle" required value="<?php echo $publicProject['title']; ?>">
        <label for="title">Title</label>
    </div>
    <!-- <div class="form-floating mb-2"> -->
    <div class="mb-2">
        <textarea name="description" id="editPublicProjectDescription" class="form-control p-2" placeholder="Public project description" rows="4" style="resize:none;"><?php echo $publicProject['description']; ?></textarea>
        <!-- <label for="description">Description</label> -->
    </div>
    <div class="form-floating mb-2">
        <select name="projectId" class="form-select form-control" id="editPublicProjectProjectId">
            <option value="">Select Portal Project</option>
            <?php foreach ( $projects as $project ) : ?>
                <option value="<?php echo $project['id']; ?>" <?php if ( $publicProject['projectId'] == $project['id'] ) : ?>selected<?php endif; ?>><?php echo $project['title']; ?></option>
            <?php endforeach; ?>
        </select>
        <label for="projectId">Project ID (if any)</label>
    </div>
    <div class="form-floating mb-2">
        <select name="status" class="form-select form-control" id="editPublicProjectStatus" required>
            <option value="">Select Status</option>
            <option value="Completed" <?php if ( $publicProject['status'] == 'Completed' ) : ?>selected<?php endif; ?>>Completed</option>
            <option value="Contracted"<?php if ( $publicProject['status'] == 'Contracted' ) : ?>selected<?php endif; ?>>Contracted</option>
            <option value="In Design"<?php if ( $publicProject['status'] == 'In Design' ) : ?>selected<?php endif; ?>>In Design</option>
            <option value="In Progress"<?php if ( $publicProject['status'] == 'In Progress' ) : ?>selected<?php endif; ?>>In Progress</option>
            <option value="Pending"<?php if ( $publicProject['status'] == 'Pending' ) : ?>selected<?php endif; ?>>Pending</option>
        </select>
        <label for="status">Status</label>
    </div>
    <div class="form-floating mb-2">
        <input type="text" name="city" class="form-control" id="editPublicProjectCity" required value="<?php echo $publicProject['city']; ?>">
        <label for="city">City</label>
    </div>
    <div class="input-group mb-2">
        <span class="input-group-text">$</span>
        <div class="form-floating form-floating-group flex-grow-1">
            <input type="number" name="value" id="editPublicProjectValue" class="form-control" value="<?php echo $publicProject['value']; ?>">
            <label for="value">Dollar Value (numbers only)</label>
        </div>
    </div>
    <div class="form-floating mb-2">
        <select name="type" class="form-select form-control" id="editPublicProjectType" required>
            <option value="">Select Type</option>
            <option value="Design & Timber MFG + Install" <?php if ( $publicProject['type'] == 'Design & Timber MFG + Install' ) : ?>selected<?php endif; ?>>Design & Timber MFG + Install</option>
            <option value="Design-Build-Dry-in" <?php if ( $publicProject['type'] == 'Design-Build-Dry-in' ) : ?>selected<?php endif; ?>>Design-Build-Dry-in</option>
            <option value="Design-Build-Turnkey" <?php if ( $publicProject['type'] == 'Design-Build-Turnkey' ) : ?>selected<?php endif; ?>>Design-Build-Turnkey</option>
            <option value="Land-Develop-Subdivide" <?php if ( $publicProject['type'] == 'Land-Develop-Subdivide' ) : ?>selected<?php endif; ?>>Land-Develop-Subdivide</option>
            <option value="Neighborhood Infrastructure" <?php if ( $publicProject['type'] == 'Neighborhood Infrastructure' ) : ?>selected<?php endif; ?>>Neighborhood Infrastructure</option>
            <option value="Out of State" <?php if ( $publicProject['type'] == 'Out of State' ) : ?>selected<?php endif; ?>>Out of State</option>
        </select>
        <label for="type">Type</label>
    </div>
    <input type="hidden" name="publicProjectId" class="form-control" id="editPublicProjectId" required value="<?php echo $publicProject['id']; ?>">
    <div id="editPublicProjectDropzone" class="d-flex justify-content-center align-items-center rounded overflow-x-scroll" style="border:1px grey dashed;min-height:200px;cursor:pointer;">
        <div id="addEditImages" class="text-center">
            <div class="fw-bold">Add Image(s)</div>
        </div>
    </div>
    <div class="small mt-1 ms-1 mb-2">
        <span class="text-muted">Drag and drop or click inside the box to upload files</span>
        <br> 
        <span class="text-muted">Max number of files:</span> 100
        <br>
        <span class="text-muted">Max size per file:</span> 30MB
        <br>
        <span class="text-muted">Max total upload size:</span> 256MB
        <br>
        <span class="text-muted">Accepted file types:</span> JPG/JPEG, PNG
    </div>
    <div id="editPublicProjectDragContainer" class="row px-2">
    <?php foreach ( $attachments as $attachment ) : 
        $attachmentId = $attachment['id'];

        if ( count($attachments) == 1 ) {
            $col     = 'col-12';
            $padding = '50%';
        } else {
            $col     = 'col-6';
            $padding = '75%';
        }

        $baseSrc  = URL_PUBLIC_PROJECT_ATTACHMENTS;
        $basePath = PATH_PUBLIC_PROJECT_ATTACHMENTS;

        $link = "$baseSrc/$attachment[filename]";
        $dl   = $link;
        $src  = $link;
        if ( file_exists("$basePath/small/$attachment[filename]") ) {
            $link = "$baseSrc/small/$attachment[filename]";
            $src  = $link;
        }
        if ( file_exists("$basePath/thumbs/$attachment[filename]") ) {
            $src = "$baseSrc/thumbs/$attachment[filename]";
        }
    ?>
            <div class="<?php echo $col; ?> p-1 publicProjectAttachmentCol editPublicProjectDragItem" data-id="<?php echo $attachment['id']; ?>">
                <div class="position-relative overflow-hidden" style="padding-bottom:<?php echo $padding; ?>;">
                <?php if ( $user['superAdmin'] ) : ?>
                    <div class="rounded-circle bg-danger position-absolute top-0 end-0 p-1" style="z-index:1;">
                        <button type="button" class="btn-close deletePublicProjectAttachment" aria-label="Close" data-id="<?php echo $attachment['id']; ?>" style="z-index:2;"></button>
                    </div>
                <?php endif; ?>
                    <a href="<?php echo $link; ?>" class="lightboxLink editPublicProjectAttachment" rel="btb-lb-<?php echo $publicProject['id']; ?>" data-fancybox="btb-post-<?php echo $publicProject['id']; ?>" data-download-src="<?php echo $dl; ?>">
                        <img 
                            data-src="<?php echo $src; ?>" 
                            alt="<?php echo $publicProject['title'] ?>" 
                            class="lazy img-thumbnail position-absolute object-fit-cover w-100 h-100"
                        >
                    </a>
                </div>
            </div>
    <?php endforeach; ?>
    </div>
<?php
    endif;
?>