<?php 
    if ( !$user['admin'] ) {
        session_start();
        $_SESSION['error'] = "Unauthorized";

        header('Location: '.URL_APP.'/dashboard/');
        exit;
    }

    session_start();
    if ( isset($_SESSION['error']) ) {
        $error = $_SESSION['error'];
        unset($_SESSION['error']);
    } else {
        $error = false;
    }

    $s = ( isset($_GET['s']) )
        ? $_GET['s']
        : 'r'
    ;
    $projectId = 9;

    include 'layout/header.php'; 
?>

<style>
</style>

<div class="container-fluid px-0">
    <?php include "template/toolbar.php"; ?>
</div>

<?php if ( $error ) : ?>
    <div class="container-fluid container-lg">
        <div class="alert alert-warning alert-dismissible fade show mb-md-0" role="alert">
            <?php echo $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
<?php endif; ?>

<div class="container-fluid p-0">
    <div class="row">
        <div class="col-3">
            <div class="d-flex justify-content-between mb-5">
                <a href="<?php echo URL_APP_ADMIN; ?>/select.php?s=c" class="text-danger">Category</a>
                <a href="<?php echo URL_APP_ADMIN; ?>/select.php?s=r" class="text-danger">Room</a>
            </div>

            <?php 
                if ( $s === 'c' ) : 
                    $categories = $db->run("SELECT * FROM selection_category");
            ?>
                <h3>Categories</h3>
                <?php 
                    foreach ( $categories as $category ) : 
                        $category['selections'] = $db->run("SELECT selection.id, selection.projectId, selection.roomId, selection.itemId, selection.note, selection_item.categoryId FROM selection, `selection_item` WHERE selection.itemId = selection_item.id AND selection.projectId = ? AND selection_item.categoryId = ?", $projectId, $category['id']);
                ?>
                    <h6><?php echo $category['title']; ?></h6>
                    <p><?php var_dump($category['selections']); ?></p>
                <?php endforeach; ?>
            <?php endif; ?>
            <?php 
                if ( $s === 'r' ) : 
                    $rooms = $db->run("SELECT * FROM selection_room WHERE projectId = ?", $projectId);

            ?>
                <h3>Rooms</h3>
                <?php 
                    foreach ( $rooms as $room ) : 
                        $selections = $db->run("SELECT * FROM selection WHERE roomId = ?", $room['id']);
                ?>
                    <h6><?php echo $room['name']; ?></h6>
                    <p><?php var_dump($selections); ?></p>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <div class="col-9 p-0">
            <iframe src="https://www.homedepot.com" style="width:100%;height:100%;border:none !important;"></iframe>
        </div>
    </div>
</div>

<?php include 'layout/footer.php'; ?>