<?php
    if ( !$user['superAdmin'] ) {
        session_start();
        $_SESSION['error'] = 'Unauthorized';
    
        header('Location: '.URL_APP_ADMIN);
        exit;
    }
    
    if ( !is_array($_POST['publicProjects']) || count($_POST['publicProjects']) < 1 ) {
        session_start();
        $_SESSION['error'] = 'Choose at least one public project';
    
        header('Location: '.URL_APP_ADMIN.'/?page=pp');
        exit;
    }
    
    if ( !$_POST['note'] ) {
        session_start();
        $_SESSION['error'] = 'A note is required';
    
        header('Location: '.URL_APP_ADMIN.'/?page=pp');
        exit;
    }

    $shareUpdate = [
        'note' => $_POST['note']
    ];

    $db->update('share', $shareUpdate, ['id' => $_POST['shareId']]);

    $db->delete('public_project_share', ['shareId' => $_POST['shareId']]);
    foreach ( $_POST['publicProjects'] as $publicProjectId ) {
        $db->insert('public_project_share', ['publicProjectId' => $publicProjectId, 'shareId' => $_POST['shareId']]);
    }

    session_start();
    $_SESSION['error'] = 'Share updated';

    header('Location: '.URL_APP_ADMIN.'/?page=pp');
    exit;
?>