<?php
if ( !$user['superAdmin'] ) {
    session_start();
    $_SESSION['error'] = 'Unauthorized';

    header('Location: '.URL_APP_ADMIN);
    exit;
}

if ( !isset($_POST['title']) || !$_POST['title'] || strlen($_POST['title']) > 128 ) {
    session_start();
    $_SESSION['error'] = 'Invalid public project title';

    header('Location: '.URL_APP_ADMIN.'/?page=pp');
    exit;
}

$description = ( isset($_POST['description']) && strlen($_POST['description']) > 0 )
    ? $_POST['description']
    : NULL
;

if ( isset($_POST['projectId']) ) {
    if ( !$project = $db->row("SELECT * FROM project WHERE id = ?", $_POST['projectId']) ) {
        $projectId = NULL;
    } else {
        $projectId = $_POST['projectId'];
    }
} else {
    $projectId = NULL;
}

if ( !isset($_POST['status']) ) {
    session_start();
    $_SESSION['error'] = 'A public project status is required';

    header('Location: '.URL_APP_ADMIN.'/?page=pp');
    exit;
}

if ( !isset($_POST['city']) ) {
    session_start();
    $_SESSION['error'] = 'A public project city is required';

    header('Location: '.URL_APP_ADMIN.'/?page=pp');
    exit;
}

if ( !isset($_POST['value']) || !is_numeric($_POST['value']) ) {
    session_start();
    $_SESSION['error'] = 'A valid public project value is required';

    header('Location: '.URL_APP_ADMIN.'/?page=pp');
    exit;
}

if ( !isset($_POST['type']) ) {
    session_start();
    $_SESSION['error'] = 'A public project type is required';

    header('Location: '.URL_APP_ADMIN.'/?page=pp');
    exit;
}

$now = date('Y-m-d H:i:s');
$db->insert('public_project', [
    'title' => $_POST['title'],
    'description' => $description,
    'projectId' => $projectId,
    'status' => $_POST['status'],
    'city' => $_POST['city'],
    'value' => $_POST['value'],
    'type' => $_POST['type'],
    'createdBy' => $user['id'],
    'createdAt' => $now
]);

$publicProject = $db->row("SELECT * FROM public_project WHERE title = ? AND description = ? AND status = ? AND city = ? AND value = ? AND type = ? AND createdBy = ? AND createdAt = ?", $_POST['title'], $description, $_POST['status'], $_POST['city'], $_POST['value'], $_POST['type'], $user['id'], $now);

if ( !empty($_FILES) ) {
    for ( $i = 0; $i < count($_FILES['file']['name']); $i++ ) {
        $ext = pathinfo($_FILES['file']['name'][$i], PATHINFO_EXTENSION);
        if ( $ext != 'JPG' && $ext != 'JPEG' && $ext != 'jpg' && $ext != 'jpeg' && $ext != 'PNG' && $ext != 'png' ) {
            session_start();
            $_SESSION['error'] = 'An upload had an invalid file type';
        
            header('Location: '.URL_APP_ADMIN.'/?page=pp');
            exit;
        } else {
            $filename = strtotime($now).'-'.$_FILES['file']['name'][$i];
            if ( move_uploaded_file($_FILES['file']['tmp_name'][$i], PATH_PUBLIC_PROJECT_ATTACHMENTS.'/'.$filename) ) {
                $db->insert('public_project_attachment', [
                    'publicProjectId' => $publicProject['id'],
                    'filename' => $filename,
                    'createdBy' => $user['id'],
                    'createdAt' => $now
                ]);
            } else {
                session_start();
                $_SESSION['error'] = 'There was an error with your file upload';
    
                header('Location: '.URL_APP_ADMIN.'/?page=pp');
                exit;
            }
        }
    }
}

session_start();
$_SESSION['error'] = 'Public project created';

if ( !isset($_POST['fromdz']) ) {
    header('Location: '.URL_APP_ADMIN.'/?page=pp');
}
exit;