<div class="row justify-content-center text-center mx-2">
    <div class="col-12 col-lg-6 px-0">
        <div class="form-floating">
            <select name="conversationId" class="form-select form-control bg-light-subtle rounded-4" id="selectConversationId">
                <option value="">New Conversation</option>
                <?php foreach ( $conversations as $convo ) : ?>
                    <option value="<?php echo $convo['id']; ?>" <?php if ( $conversation['id'] === $convo['id'] ) : ?>selected<?php endif; ?>>
                        <?php echo $convo['createdAt'] . ' - ' . substr($convo['message'], 0, 30) . '...'; ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <label class="small" for="conversationId">Your AI Conversations</label>
        </div>
<form id="aiConversation" method="POST" name="aiConversation" novalidate="novalidate" enctype="multipart/form-data">
        <?php if ( !isset($conversation) || !$conversation ) : ?>
            <textarea id="systemPrompt" name="systemPrompt" class="form-control bg-light-subtle rounded-4 my-4" placeholder="Set a system prompt for this conversation (optional)" rows="4" style="resize:none;width:100%;max-height:240px;"></textarea>
        <?php elseif ( $conversation['systemPrompt'] ) : ?>
            <textarea id="systemPrompt" name="systemPrompt" class="form-control bg-light-subtle rounded-4 my-4" rows="4" disabled readonly="true" style="resize:none;width:100%;max-height:240px;"><?php echo nl2br(htmlspecialchars($conversation['systemPrompt'])); ?></textarea>
        <?php endif; ?>
        <hr class="my-4">

    </div>
</div>
<div id="responseRow" class="row justify-content-center mx-2 mb-1">
    <div id="response" class="col-12 col-lg-6 bg-light-subtle border rounded-4 p-2">
        <?php
            if ( isset($conversation) && $conversation ) {
                $i = 0;
                foreach( $conversation['messages'] as $message ) {
                    // var_dump($message);
                    include 'ai-message.php';
                    $i++;
                }
            } else {
        ?>
                <div id="newConversationWrapper">
                    <h3>AI Console</h3>
                    <p class="lead">Start a conversation with Claude AI. Type your message into the text field at the bottom of the page and press <kbd>Return</kbd> to send the message.</p>
                    <p class="lead">Press <kbd>Shift</kbd> + <kbd>Return</kbd> to break to a new line.</p>
                    <p class="lead">You can resume a previous conversation by selecting it from the dropdown menu near the top of the page.</p>
                    <p class="lead">Claude will accept file uploads of the following types: <code>PDF</code>, <code>JPG/JPEG</code>, <code>PNG</code>, <code>WEBP</code> (max 10, 25MB each).</p>
                </div>
        <?php 
            } 
        ?>
    </div>
</div>

<div id="conversationTokensContainer" class="row justify-content-center mb-4">
    <div class="col-6 text-end text-nowrap">
        <span class="small text-muted">
            <span id="conversationTokens"><?php echo $conversationTokens ?? '0'; ?></span> tokens used in this conversation
        </span>
    </div>
</div>

<div id="promptRow" class="row justify-content-center fixed-bottom mx-1">
    <div class="col-12 col-lg-6 bg-light-subtle rounded-top-4 border border-bottom-0 shadow">
        <div id="conversationToolbar" class="hstack gap-2 align-items-center py-2 px-0">
            <label id="aiAttachment" class="aiToolbarBtn btn p-0" for="files">
                <i class="bi bi-paperclip"></i>
                <input type="file" name="files[]" id="files" multiple="true" accept="image/jpeg,image/png,image/webp,application/pdf" style="display:none;">
            </label>
            <!-- <span id="selectedFiles" class="d-inline-block small text-muted text-truncate">Attach files (max 10, 25MB each)</span> -->
            <span id="selectedFiles" class="d-inline-block small text-muted text-truncate"></span>
            <button id="aiSendMessage" type="submit" class="aiToolbarBtn btn p-0 ms-auto">
                <i class="bi bi-send"></i>
            </button>
        </div>
        <?php
            $placeholder = ( isset($conversation) && $conversation )
                ? 'Continue your conversation...'
                : 'Start a conversation...'
            ;
        ?>
        <textarea id="prompt" name="prompt" class="form-control bg-light-subtle border-0 pt-0 px-0" placeholder="<?php echo $placeholder; ?>" rows="2" style="resize:none;width:100%;height:100%;max-height:240px;"></textarea>
    </div>
</div>


<?php
    $value = ( isset($conversation) && $conversation )
        ? $conversation['id']
        : ''
    ;
?>
<input type="hidden" name="conversationId" id="conversationId" value="<?php echo $value; ?>">

</form>