<div id="newProjectModal" class="modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">New Project</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo URL_APP_ADMIN; ?>/src/new-project.php" method="POST" id="newProjectForm">
                <div id="newProjectModalBody" class="modal-body">
                    <div class="form-floating mb-2">
                        <input type="text" name="title" class="form-control" id="title" required>
                        <label for="name">Title</label>
                    </div>
                    <div class="form-floating mb-2">
                        <select id="status" name="status" class="form-select form-control">
                            <option value="">Select project status</option>
                            <option value="Active">Active</option>
                            <option value="Completed">Completed</option>
                            <option value="Negotiating">Negotiating</option>
                            <option value="Paused">Paused</option>
                        </select>
                        <label for="status">Project status</label>
                    </div>
                    <div class="input-group mb-2">
                        <div class="form-floating">
                            <!-- <input type="text" name="sheetId" class="form-control" id="sheetId" required> -->
                            <select id="newProjectTaskListSelect" name="sheetId" class="form-select form-control" required>
                                <option value="">Loading sheets...</option>
                            </select>
                            <label for="sheetId">Sheet ID</label>
                        </div>
                        <label id="newProjectTaskListLoader" class="input-group-text">
                            <div class="d-flex">
                                <div class="spinner-border spinner-border-sm text-danger" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                        </label>
                    </div>
                    <div class="form-floating mb-2">
                        <input type="text" name="zip" class="form-control" id="zip" required>
                        <label for="email">ZIP (used to fetch weather)</label>
                    </div>
                    <div class="form-floating mb-2">
                        <input type="text" name="city" class="form-control" id="city" required>
                        <label for="email">City (used for display only)</label>
                    </div>
                    <div class="form-check text-start mx-1">
                        <input class="form-check-input" type="checkbox" id="addClientProject" name="addClientProject" value="1">
                        <label class="form-check-label" for="addClientProject">
                            Add client(s) to project
                        </label>
                    </div>
                    <div class="d-none mx-1" id="clientProject">
                        <select name="clients[]" class="selectpicker my-1" multiple data-live-search="true" title="Select clients" data-selected-text-format="count > 2" data-width="100%">
                            <?php 
                                foreach ( $clientUsers as $cUser ) : 
                                    if ( $cUser['clientId'] ) :
                            ?>
                                        <option value="<?php echo $cUser['clientId']; ?>"><?php echo $cUser['name']; ?></option>
                            <?php
                                    endif;
                                endforeach; 
                            ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger btbAction" data-action="click" data-target="save new project">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>