<div class="d-flex align-items-center justify-content-between">
    <div class="d-block">
        <span class="fw-bold">Projects (<?php echo count($projects); ?>)</span>
    </div>
    <div class="d-block">
        <?php if ( $user['superAdmin'] ) : ?>
            <button type="button" class="btn btn-sm btn-danger" title="New project" data-bs-toggle="modal" data-bs-target="#newProjectModal">
                <i class="bi bi-plus"></i>
            </button>
        <?php endif; ?>
    </div>
</div>

<div class="row px-1">
    <?php foreach ( $projects as $project ) : ?>
        <div class="col-12 col-md-6 col-lg-4 col-xl-3 g-3 mb-1">
            <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <span class="fw-bold">
                        <a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>" class="text-danger">
                            <?php echo $project['title']; ?>
                        </a>
                    </span>
                    <button class="btn dropdown-toggle" type="button" data-bs-toggle="dropdown" style="border:none;">
                        <i class="bi bi-three-dots"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <?php if ( $user['superAdmin'] ) : ?>
                            <li><h6 class="dropdown-header">Super Admin</h6></li>
                            <?php if ( !$project['webhook'] ) : ?>
                                <li><a class="dropdown-item btbAction" data-action="click" data-target="create webhook for project <?php echo $project['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/webhook/create.php/?projectId=<?php echo $project['id']; ?>">Create Webhook</a></li>
                            <?php endif; ?>
                            <li><a class="dropdown-item editProjectButton btbAction" data-action="click" data-target="edit project <?php echo $project['id']; ?> button" href="" data-id="<?php echo $project['id']; ?>" data-bs-toggle="modal" data-bs-target="#editProjectModal">Edit</a></li>
                            <li><a class="dropdown-item btbAction" data-action="click" data-target="fetch project <?php echo $project['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/fetch.php/?projectId=<?php echo $project['id']; ?>">Fetch</a></li>
                            <li><hr class="dropdown-divider"></li>
                        <?php endif; ?>
                        <li><h6 class="dropdown-header">Admin</h6></li>
                        <li><a class="dropdown-item btbAction" data-action="click" data-target="view project <?php echo $project['id']; ?> button" href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>">View</a></li>
                    </ul>
                </div>
                <div class="card-body p-0">
<?php
                    $attachment = $project['attachment'];
                    $src = URL_ATTACHMENTS."/$attachment[pathname]";
                    if ( file_exists(PATH_ATTACHMENTS."/small/$attachment[pathname]") ) {
                        $src = URL_ATTACHMENTS."/small/$attachment[pathname]";
                    }
                    if ( file_exists(PATH_ATTACHMENTS."/thumbs/$attachment[pathname]") ) {
                        $src = URL_ATTACHMENTS."/thumbs/$attachment[pathname]";
                    }
?>
                    <div class="position-relative overflow-hidden" style="padding-bottom:75%;">
                        <a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>">
                            <img data-src="<?php echo $src; ?>" class="lazy card-img position-absolute object-fit-cover w-100 h-100" style="border-radius:0;" title="<?php echo $project['title']; ?>" alt="<?php echo $project['title']; ?>"/>
                        </a>
                    </div>

                    <div class="p-3">
                        <ul class="list-group list-group-flush">
                            <?php if ( $project['clients'] ) : ?>
                                <li class="list-group-item d-flex align-items-center justify-content-between">
                                    <span class="small text-muted text-start text-truncate">Client(s)</span>
                                    <div class="hstack gap-1">
<?php
                                        foreach ( $project['clients'] as $projectClient ) :
                                            if ( $user['superAdmin'] ) :
?>
                                                <a class="editClientButton link-underline link-underline-opacity-0" href="" data-id="<?php echo $projectClient['id']; ?>" data-bs-toggle="modal" data-bs-target="#editClientModal">
<?php
                                            endif;
                                            if ( !file_exists(PATH_ASSETS.'/images/avatar/'.$projectClient['name'].'.jpg')) :
                                                $parts    = explode(' ', $projectClient['name']);
                                                $initials = substr($parts[0], 0, 1) . substr(end($parts), 0, 1);
?>
                                                <div class="initial-avatar-notifications flex-shrink-0" alt="<?php echo $projectClient['name']; ?>" title="<?php echo $projectClient['name']; ?>"><?php echo $initials; ?></div>
<?php
                                            else :
?>
                                                <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $projectClient['name']; ?>.jpg" alt="<?php echo $projectClient['name']; ?>" title="<?php echo $projectClient['name']; ?>" class="avatar-small" style="width:32px;height:32px;">
<?php
                                            endif;
                                            if ( $user['superAdmin'] ) :
?>
                                                </a>
<?php
                                            endif;
                                        endforeach;
?>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <li class="list-group-item d-flex align-items-center justify-content-between">
                                <span class="small text-muted text-start text-truncate">Project ID</span>
                                <span class="small text-end"><?php echo $project['id']; ?></span>
                            </li>
                            <li class="list-group-item d-flex align-items-center justify-content-between">
                                <span class="small text-muted text-start text-truncate">Sheet ID</span>
                                <span class="small text-end"><?php echo $project['sheetId']; ?></span>
                            </li>
                            <li class="list-group-item d-flex align-items-center justify-content-between">
                                <span class="small text-muted text-start text-truncate">Location</span>
                                <span class="small text-end"><?php echo $project['city']; ?> <?php echo $project['zip']; ?></span>
                            </li>
                            <?php if ( $project['notifications'] ) : ?>
                                <li class="list-group-item d-flex align-items-center justify-content-between">
                                    <span class="small text-muted text-start text-truncate">Notify</span>
                                    <div class="hstack gap-1">
<?php
                                        foreach ( $project['notifications'] as $notification ) :
                                            if ( $user['superAdmin'] ) :
?>
                                                <a class="editUserButton link-underline link-underline-opacity-0" href="" data-id="<?php echo $notification['id']; ?>" data-bs-toggle="modal" data-bs-target="#editUserModal">
<?php
                                            endif;
                                            if ( !file_exists(PATH_ASSETS.'/images/avatar/'.$notification['name'].'.jpg')) :
                                                $parts    = explode(' ', $notification['name']);
                                                $initials = substr($parts[0], 0, 1) . substr(end($parts), 0, 1);
?>
                                                <div class="initial-avatar-notifications flex-shrink-0" alt="<?php echo $notification['name']; ?>" title="<?php echo $notification['name']; ?>"><?php echo $initials; ?></div>
<?php
                                            else :
?>
                                                <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $notification['name']; ?>.jpg" alt="<?php echo $notification['name']; ?>" title="<?php echo $notification['name']; ?>" class="avatar-small" style="width:32px;height:32px;">
<?php
                                            endif;
                                            if ( $user['superAdmin'] ) :
?>
                                                </a>
<?php
                                            endif;
                                        endforeach;
?>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between small">
                    <div class="d-block text-start">
                        <div class="text-muted">Started</div>
                        <a role="button" data-bs-toggle="tooltip" data-bs-title="<?php echo $project['createdAt']; ?>" class="text-danger p-0">
                            <span><?php echo time_elapsed_string($project['createdAt']); ?></span>
                        </a>
                    </div>
                    <div class="vr"></div>
                    <div class="d-block text-end">
                        <div class="text-muted">Updated</div>
                        <a role="button" data-bs-toggle="tooltip" data-bs-title="<?php echo $project['updatedAt']; ?>" class="text-danger p-0">
                            <span><?php echo time_elapsed_string($project['updatedAt']); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>