<div class="d-flex align-items-center justify-content-between">
    <div class="d-block">
        <span class="fw-bold">Share Links (<?php echo count($shares); ?>)</span>
    </div>
    <div class="d-block">
        <?php if ( $user['superAdmin'] ) : ?>
            <button type="button" class="btn btn-sm btn-danger" title="New share link" data-bs-toggle="modal" data-bs-target="#newPublicProjectShareModal">
                <i class="bi bi-plus"></i>
            </button>
        <?php endif; ?>
    </div>
</div>
<div id="publicProjectsShareTable" class="table-responsive">
    <table id="publicProjectsShareDT" class="table table-striped table-bordered table-hover table-sm border-top border-bottom">
        <thead class="">
            <tr class="text-center">
                <!-- <th></th> -->
                <th scope="col">#</th>
                <th scope="col">ID</th>
                <th scope="col">Project(s)</th>
                <th scope="col">Link</th>
                <th scope="col">Note</th>
                <th scope="col">Creator</th>
                <th scope="col">Created</th>
                <th scope="col">Expires</th>
                <th scope="col">Actions</th>
            </tr>
        </thead>
        <tbody class="">
<?php
                $i = 1;
                foreach ( $shares as $share ) : 
?>
                <tr class="text-center">
                    <!-- <td></td> -->
                    <td><?php echo $i; ?></td>
                    <td><?php echo $share['id']; ?></td>
                    <td>
                        <?php 
                            if ( is_array($share['publicProjects']) ) :
                        ?>
                            <a role="button" data-bs-toggle="tooltip" data-bs-html="true" data-bs-title="<?php echo implode('<br>', array_column($share['publicProjects'], 'title')); ?>" class="text-danger p-0">
                                <?php echo count($share['publicProjects']); ?>
                            </a>
                        <?php
                            endif;
                        ?>
                    </td>
                    <td>
                        <div class="d-flex justify-content-between align-items-center px-2">
                            <a href="<?php echo URL_PUBLIC_PROJECTS.'/'.$share['uri'].'/'; ?>" target="_blank" class="text-danger">
                                <?php echo URL_PUBLIC_PROJECTS.'/'.$share['uri'].'/'; ?>
                            </a>
                            <button class="btn btn-sm btn-danger copyPublicProjectShareLink ms-3" type="button" role="button" title="Copy" data-clipboard-text="<?php echo URL_PUBLIC_PROJECTS.'/'.$share['uri'].'/'; ?>">
                                <i class="bi bi-copy"></i>
                            </button>
                        </div>
                    </td>
                    <td class="text-truncate"><?php echo $share['note']; ?></td>
                    <td>
                        <?php if ( $user['superAdmin'] ) : ?>
                            <a class="editUserButton btbAction text-danger" data-action="click" data-target="edit user <?php echo $share['user']['id']; ?> button" href="" data-id="<?php echo $share['user']['id']; ?>" data-bs-toggle="modal" data-bs-target="#editUserModal"><?php echo $share['user']['name']; ?></a>
                        <?php else : ?>
                            <?php echo $share['user']['name']; ?>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a role="button" class="text-danger p-0" data-bs-toggle="tooltip" data-bs-title="<?php echo $share['createdAt']; ?>">
                            <?php echo time_elapsed_string($share['createdAt']); ?>
                        </a>
                    </td>
                    <td>
                        <?php
                            $now = time();
                            $exp = strtotime($share['expiresAt']);
                            if ( $now > $exp ) :
                        ?>
                            <span class="text-warning">Expired</span>
                        <?php else : ?>
                            <a role="button" class="text-danger p-0" data-bs-toggle="tooltip" data-bs-title="<?php echo $share['expiresAt']; ?>">
                                <?php echo time_until_string($share['expiresAt']); ?>
                            </a>
                        <?php endif; ?>
                    </td>
                    <td class="text-center">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" style="--bs-btn-padding-y: .25rem; --bs-btn-padding-x: .5rem; --bs-btn-font-size: .75rem;">
                                Actions
                            </button>
                            <ul class="dropdown-menu">
                                <?php if ( $user['superAdmin'] ) : ?>
                                    <li><h6 class="dropdown-header">Super Admin</h6></li>
                                    <li><a class="dropdown-item editPublicProjectShareButton btbAction" data-action="click" data-target="edit public project share <?php echo $share['id']; ?> button" href="" data-id="<?php echo $share['id']; ?>" data-bs-toggle="modal" data-bs-target="#editPublicProjectShareModal">Edit</a></li>
                                    <li><a href="<?php echo URL_APP_ADMIN; ?>/src/delete-public-project-share.php?id=<?php echo $share['id']; ?>" class="dropdown-item btbAction" data-action="click" data-target="delete public project share <?php echo $share['id']; ?> button" data-id="<?php echo $share['id']; ?>">Delete</a></li>
                                    <li><a class="dropdown-item viewShareLogsButton btbAction" data-action="click" data-target="view public project <?php echo $share['id']; ?> share logs button" href="" data-id="<?php echo $share['id']; ?>" data-bs-toggle="modal" data-bs-target="#shareLogsModal">View logs</a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php 
                    $i++;
                endforeach;
            ?>
        </tbody>
    </table>
</div>

<hr>

<div class="d-flex align-items-center justify-content-between">
    <div class="d-block">
        <span class="fw-bold">Public Projects (<?php echo count($publicProjects); ?>)</span>
    </div>
    <div class="d-block">
        <?php if ( $user['superAdmin'] ) : ?>
            <!-- <a type="button" class="btn btn-danger btbAction" data-action="click" data-target="fetch all button" href="<?php echo URL_APP_ADMIN; ?>/src/fetch.php">Fetch All</a> -->
            <button type="button" class="btn btn-sm btn-danger" title="New public project" data-bs-toggle="modal" data-bs-target="#newPublicProjectModal">
                <i class="bi bi-plus"></i>
            </button>
        <?php endif; ?>
    </div>
</div>

<div id="publicProjectsTable" class="table-responsive">
    <table id="publicProjectsDT" class="table table-striped table-bordered table-hover table-sm border-top border-bottom">
        <thead class="">
            <tr class="text-center">
                <!-- <th></th> -->
                <!-- <th scope="col">
                    <input class="form-check-input publicProjectsCheck" id="publicProjectsCheckAll" type="checkbox" value="all" name="publicProjectsCheckAll">
                </th> -->
                <th scope="col">#</th>
                <th scope="col">ID</th>
                <th scope="col">Title</th>
                <th scope="col">Status</th>
                <th scope="col">Location</th>
                <th scope="col">Value</th>
                <th scope="col">Type</th>
                <th scope="col">Portal Project</th>
                <th scope="col">Actions</th>
                <!-- <th scope="col"></th> -->
            </tr>
        </thead>
        <tbody class="">
<?php
                $i = 1;
                foreach ( $publicProjects as $publicProject ) : 
?>
                <tr class="text-center">
                    <!-- <td></td> -->
                    <!-- <td><input class="form-check-input publicProjectsCheck" type="checkbox" value="<?php echo $publicProject['id']; ?>" data-id="<?php echo $publicProject['id']; ?>"></td> -->
                    <td><?php echo $i; ?></td>
                    <td><?php echo $publicProject['id']; ?></td>
                    <td class="fw-bold">
                        <!-- <a href="#" class="text-danger text-truncate">
                            <?php echo $publicProject['title']; ?>
                        </a> -->
                        <?php if ( $user['superAdmin'] ) : ?>
                            <a class="editPublicProjectButton btbAction text-danger text-truncate" data-action="click" data-target="edit public project <?php echo $publicProject['id']; ?> button" href="" data-id="<?php echo $publicProject['id']; ?>" data-bs-toggle="modal" data-bs-target="#editPublicProjectModal">
                                <?php echo $publicProject['title']; ?>
                            </a>
                        <?php else : ?>
                            <?php echo $publicProject['title']; ?>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php
                            switch ( $publicProject['status'] ) {
                                case 'Completed' :
                                    $class = 'text-bg-success';
                                    break;
                                case 'Contracted' :
                                    $class = 'text-bg-info';
                                    break;
                                case 'In Design' :
                                    $class = 'text-bg-light';
                                    break;
                                case 'In Progress' :
                                    $class = 'text-bg-primary';
                                    break;
                                case 'Pending' :
                                    $class = 'text-bg-warning';
                                    break;
                            }
                        ?>
                        <span class="badge rounded-pill py-2 <?php echo $class; ?>"><?php echo $publicProject['status']; ?></span>
                    </td>
                    <td><?php echo $publicProject['city'].', '.COMPANY_STATE_ABBR; ?></td>
                    <td class="text-success fw-bold">
                        $<?php echo number_format($publicProject['value'], 0); ?>
                    </td>
                    <td><?php echo $publicProject['type']; ?></td>
                    <td>
                        <?php if ( $publicProject['projectId'] ) : ?>
                            <a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $publicProject['projectId']; ?>" class="text-danger">
                                <?php echo $publicProject['project']['title']; ?>
                            </a>
                        <?php else : ?>
                            <span class="text-warning">Not in Portal</span>
                        <?php endif; ?>
                    </td>
                    <td class="text-center">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" style="--bs-btn-padding-y: .25rem; --bs-btn-padding-x: .5rem; --bs-btn-font-size: .75rem;">
                                Actions
                            </button>
                            <ul class="dropdown-menu">
                                <?php if ( $user['superAdmin'] ) : ?>
                                    <li><h6 class="dropdown-header">Super Admin</h6></li>
                                    <li><a class="dropdown-item editPublicProjectButton btbAction" data-action="click" data-target="edit public project <?php echo $publicProject['id']; ?> button" href="" data-id="<?php echo $publicProject['id']; ?>" data-bs-toggle="modal" data-bs-target="#editPublicProjectModal">Edit</a></li>
                                    <li><a class="dropdown-item sharePublicProjectButton btbAction" data-action="click" data-target="share public project <?php echo $publicProject['id']; ?> button" href="" data-id="<?php echo $publicProject['id']; ?>" data-bs-toggle="modal" data-bs-target="#newPublicProjectShareModal">Share</a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </td>
                    <!-- <td> -->
                        <?php //foreach ( $publicProject['shares'] as $share ) : ?>
                            <!-- <div class="hstack gap-2">
                                <span><span class="small text-muted">ID: </span><?php echo $share['id']; ?></span>
                                <span><span class="small text-muted">URL: </span><a href="https://bigtimberbuilders.com/p/<?php echo $share['uri']; ?>/" target="_blank" class="text-danger">https://bigtimberbuilders.com/p/<?php echo $share['uri']; ?>/</a></span>
                                <span><span class="small text-muted">Note: </span><?php echo $share['note']; ?></span>
                                <span><span class="small text-muted">Created: </span><?php echo time_elapsed_string($share['createdAt']); ?></span>
                            </div> -->
                        <?php //endforeach; ?>
                    <!-- </td> -->
                </tr>
            <?php 
                    $i++;
                endforeach;
            ?>
        </tbody>
    </table>
</div>