<div id="usersTable" class="table-responsive px-3 collapse">
    <table id="usersDT" class="table table-striped table-bordered table-hover table-sm border-top border-bottom w-100">
        <thead>
            <tr class="text-center">
                <th scope="col">#</th>
                <th scope="col">ID</th>
                <th scope="col">Name</th>
                <th scope="col">Email</th>
                <th scope="col">Smartsheet Email</th>
                <th scope="col">Is Admin</th>
                <th scope="col">Is Super Admin</th>
                <th scope="col">Is Active</th>
                <th scope="col">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $i = 1;
                foreach( $viewOnlyUsers as $u ) : 
                    // $u['user'] = $db->row("SELECT * FROM user WHERE id = ?", $u['userId']);
            ?>
                <tr class="text-center">
                    <td><?php echo $i; ?></td>
                    <td><?php echo $u['id']; ?></td>
                    <td class="fw-bold">
                        <?php if ( $user['superAdmin'] ) : ?>
                            <a class="editUserButton btbAction text-danger" data-action="click" data-target="edit user <?php echo $u['id']; ?> button" href="" data-id="<?php echo $u['id']; ?>" data-bs-toggle="modal" data-bs-target="#editUserModal"><?php echo $u['name']; ?></a>
                        <?php else : ?>
                            <?php echo $u['name']; ?>
                        <?php endif; ?>
                    </td>
                    <td><?php echo $u['email']; ?></td>
                    <td><?php echo $u['ssEmail']; ?></td>
                    <td>
                        <?php 
                            $admin = ( $u['admin'] )
                                ? 'Yes'
                                : 'No'
                            ;
                            echo $admin;
                        ?>
                    </td>
                    <td>
                        <?php 
                            $superAdmin = ( $u['superAdmin'] )
                                ? 'Yes'
                                : 'No'
                            ;
                            echo $superAdmin;
                        ?>
                    </td>
                    <td>
                        <?php 
                            $active = ( $u['active'] )
                                ? 'Yes'
                                : 'No'
                            ;
                            echo $active;
                        ?>
                    </td>
                    <td class="text-center">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" style="--bs-btn-padding-y: .25rem; --bs-btn-padding-x: .5rem; --bs-btn-font-size: .75rem;">
                                Actions
                            </button>
                            <ul class="dropdown-menu">
                                <?php if ( $user['superAdmin'] ) : ?>
                                    <li><h6 class="dropdown-header">Super Admin</h6></li>
                                    <li><a class="dropdown-item editUserButton btbAction" data-action="click" data-target="edit user <?php echo $u['id']; ?> button" href="" data-id="<?php echo $u['id']; ?>" data-bs-toggle="modal" data-bs-target="#editUserModal">Edit</a></li>
                                    <li><a class="dropdown-item btbAction" data-action="click" data-target="impersonate user <?php echo $u['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/impersonate.php?id=<?php echo $u['id']; ?>">Impersonate</a></li>
                                    <li><a class="dropdown-item btbAction" data-action="click" data-target="logout all devices user <?php echo $u['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/logout-all-devices.php?id=<?php echo $u['id']; ?>">Log out all devices</a></li>
                                    <li><a class="dropdown-item viewUserLogsButton btbAction" data-action="click" data-target="view user <?php echo $u['id']; ?> logs button" href="" data-id="<?php echo $u['id']; ?>" data-bs-toggle="modal" data-bs-target="#userLogsModal">View logs</a></li>
                                <?php endif; ?>
                                <!-- <li><a class="dropdown-item viewClientLogsButton" href="" data-id="<?php // echo $u['id']; ?>" data-bs-toggle="modal" data-bs-target="#clientLogsModal">View logs</a></li> -->
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php 
                    $i++;
                endforeach;
            ?>
        </tbody>
    </table>
</div>