
<?php

function makeLowesRequest($url, $cookies = '') {
    $ch = curl_init();
    
    $headers = [
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
        'Accept-Encoding: gzip, deflate, br',
        'Accept-Language: en-US,en;q=0.9',
        'Cache-Control: max-age=0',
        'Connection: keep-alive',
        'sec-ch-ua: "Google Chrome";v="119", "Chromium";v="119", "Not?A_Brand";v="24"',
        'sec-ch-ua-mobile: ?0',
        'sec-ch-ua-platform: "Windows"',
        'Sec-Fetch-Dest: document',
        'Sec-Fetch-Mode: navigate',
        'Sec-Fetch-Site: none',
        'Sec-Fetch-User: ?1',
        'Upgrade-Insecure-Requests: 1',
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',
        'X-Forwarded-For: ' . rand(1, 255) . '.' . rand(1, 255) . '.' . rand(1, 255) . '.' . rand(1, 255)
    ];

    // Add cookies to headers if they exist
    if (!empty($cookies)) {
        $headers[] = 'Cookie: ' . $cookies;
    }

    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_ENCODING => '',
        CURLOPT_CONNECTTIMEOUT => 30,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HEADER => true, // Include headers in response
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',
        CURLOPT_REFERER => 'https://www.lowes.com/',
    ]);

    // Add a delay to simulate human behavior
    sleep(rand(1, 3));

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    
    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
        return false;
    }

    curl_close($ch);

    // Split response into headers and body
    $headers = substr($response, 0, $headerSize);
    $body = substr($response, $headerSize);

    // Extract cookies from headers
    $cookies_array = [];
    preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $headers, $matches);
    foreach($matches[1] as $cookie) {
        $cookies_array[] = $cookie;
    }

    return [
        'body' => $body,
        'cookies' => implode('; ', $cookies_array),
        'http_code' => $httpCode
    ];
}

// First request to homepage to get cookies
echo "Making request to homepage...\n";
$homepage_result = makeLowesRequest('https://www.lowes.com/');

if ($homepage_result) {
    echo "Homepage HTTP Status Code: " . $homepage_result['http_code'] . "\n";
    echo "Cookies received: " . $homepage_result['cookies'] . "\n\n";

    // Wait a bit before making the second request
    sleep(2);

    // Make request to product page with cookies
    echo "Making request to product page...\n";
    $url = 'https://www.lowes.com/pd/ORTHO-Groundclear-Ready-to-Use-1-Gallon-Weed-and-Grass-Killer/1000833738';
    $product_result = makeLowesRequest($url, $homepage_result['cookies']);

    if ($product_result) {
        echo "Product page HTTP Status Code: " . $product_result['http_code'] . "\n";
        
        if ($product_result['http_code'] == 200) {
            // file_put_contents('lowes_page.html', $product_result['body']);
            echo $product_result['body'];
        } else {
            echo "Failed to get product page. Status code: " . $product_result['http_code'] . "\n";
        }
    }
} else {
    echo "Failed to get homepage\n";
}

?>