<?php

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.openweathermap.org/data/3.0/onecall?lat=33.44&lon=-94.04&appid=6ac59cfe89efa30a2359dd9462cdaf61&units=imperial");
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json, Content-Type: application/json']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = json_decode(curl_exec($ch));
curl_close($ch);

include '../layout/header.php';

echo "<pre>";
print_r($response);
echo "</pre>";
?>
<div class="container p-2">
    <div class="hstack gap-4 overflow-x-scroll ">
        <?php foreach ( $response->hourly as $hour ) : ?>
            <div class="vstack gap-2 justify-content-center align-items-center flex-nowrap text-nowrap p-2 border rounded">
                <strong><?php echo date('ga', $hour->dt); ?></strong>
                <span><?php echo round($hour->temp); ?>&deg;F</span>
                <img src="/clients/assets/images/weather/<?php echo $hour->weather[0]->icon; ?>@2x.png" width="50px;">
                <small class="text-muted"><?php echo $hour->weather[0]->description; ?></small>
            </div>
        <?php endforeach; ?>
    </div>
</div>
<?php
include '../layout/footer.php';