<?php

if ( !$user ) {
    http_response_code(403);
    exit;
}

if ( !isset($_POST['latestDate']) ) {
    http_response_code(400);
    exit;
}

$latestDate = $_POST['latestDate'];

//don't update or insert, because the date passed in is earlier than the latestDate stored in the table
if ( $db->cell("SELECT latestDate FROM notification_view WHERE userId = ? AND latestDate > ?", $user['id'], $_POST['latestDate']) ) {
    http_response_code(200);
    exit;
}

if ( !$exists = $db->cell("SELECT id FROM notification_view WHERE userId = ?", $user['id']) ) {
    $db->insert('notification_view', ['userId' => $user['id'], 'latestDate' => $latestDate]);
} else {
    $db->update('notification_view', ['latestDate' => $latestDate], ['userId' => $user['id']]);
}