<?php 
    if ( !$user['superAdmin'] ) {
        session_start();
        $_SESSION['error'] = "Unauthorized";

        header('Location: '.URL_APP_ADMIN);
        exit;
    }

    session_start();
    if ( isset($_SESSION['error']) ) {
        $error = $_SESSION['error'];
        unset($_SESSION['error']);
    } else {
        $error = false;
    }

    $charts = [
        'attachments',
        'comments',
        'days',
        'devices',
        'likes',
        'projects',
        'tasks',
        'visits'
    ];
    $chart = ( isset($_GET['c']) && in_array($_GET['c'], $charts) )
        ? $_GET['c']
        : 'comments'
    ;
    switch ( $chart ) {
        case 'attachments':
            $chartTitle = 'Attachments';
            break;
        case 'comments':
            $chartTitle = 'Comments & Replies';
            break;
        case 'days':
            $chartTitle = 'Days Since Created vs Days Logged In';
            break;
        case 'devices':
            $chartTitle = 'Client Devices';
            break;
        case 'likes':
            $chartTitle = 'Client Likes';
            break;
        case 'projects':
            $chartTitle = 'Days Since Created vs Days Updated';
            break;
        case 'tasks':
            $chartTitle = 'Tasks Completed';
            break;
        case 'visits':
            $chartTitle = 'Average Daily Visits';
            break;
    }

    include 'layout/header.php'; 
?>

<style>
</style>

<div class="container-fluid px-0">
    <?php include "template/toolbar.php"; ?>
</div>

<?php if ( $error ) : ?>
    <div class="container-fluid container-lg">
        <div class="alert alert-warning alert-dismissible fade show mb-md-0" role="alert">
            <?php echo $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
<?php endif; ?>

<div id="chartList" class="container-fluid bg-light-subtle border-bottom overflow-x-scroll collapse show px-0 py-3">
    <div class="hstack gap-3 align-items-center px-3">

        <div class="card flex-shrink-0 text-center shadow p-3">
            <img src="<?php echo URL_ASSETS ?>/images/pie-chart.png" style="width:64px;" class="mb-2">
            <a href="<?php echo URL_APP; ?>/analytics/?c=attachments" class="stretched-link link-underline link-underline-opacity-0">
                <span class="small text-muted">Attachments</span>
            </a>
        </div>

        <div class="card flex-shrink-0 text-center shadow p-3">
            <img src="<?php echo URL_ASSETS ?>/images/bar-chart.png" style="width:64px;" class="mb-2">
            <a href="<?php echo URL_APP; ?>/analytics/?c=comments" class="stretched-link link-underline link-underline-opacity-0">
                <span class="small text-muted">Comments</span>
            </a>
        </div>

        <div class="card flex-shrink-0 text-center shadow p-3">
            <img src="<?php echo URL_ASSETS ?>/images/bar-chart.png" style="width:64px;" class="mb-2">
            <a href="<?php echo URL_APP; ?>/analytics/?c=days" class="stretched-link link-underline link-underline-opacity-0">
                <span class="small text-muted">Days</span>
            </a>
        </div>

        <div class="card flex-shrink-0 text-center shadow p-3">
            <img src="<?php echo URL_ASSETS ?>/images/pie-chart.png" style="width:64px;" class="mb-2">
            <a href="<?php echo URL_APP; ?>/analytics/?c=devices" class="stretched-link link-underline link-underline-opacity-0">
                <span class="small text-muted">Devices</span>
            </a>
        </div>

        <div class="card flex-shrink-0 text-center shadow p-3">
            <img src="<?php echo URL_ASSETS ?>/images/bar-chart.png" style="width:64px;" class="mb-2">
            <a href="<?php echo URL_APP; ?>/analytics/?c=likes" class="stretched-link link-underline link-underline-opacity-0">
                <span class="small text-muted">Likes</span>
            </a>
        </div>

        <div class="card flex-shrink-0 text-center shadow p-3">
            <img src="<?php echo URL_ASSETS ?>/images/bar-chart.png" style="width:64px;" class="mb-2">
            <a href="<?php echo URL_APP; ?>/analytics/?c=projects" class="stretched-link link-underline link-underline-opacity-0">
                <span class="small text-muted">Projects</span>
            </a>
        </div>

        <div class="card flex-shrink-0 text-center shadow p-3">
            <img src="<?php echo URL_ASSETS ?>/images/pie-chart.png" style="width:64px;" class="mb-2">
            <a href="<?php echo URL_APP; ?>/analytics/?c=tasks" class="stretched-link link-underline link-underline-opacity-0">
                <span class="small text-muted">Tasks</span>
            </a>
        </div>

        <div class="card flex-shrink-0 text-center shadow p-3">
            <img src="<?php echo URL_ASSETS ?>/images/pie-chart.png" style="width:64px;" class="mb-2">
            <a href="<?php echo URL_APP; ?>/analytics/?c=visits" class="stretched-link link-underline link-underline-opacity-0">
                <span class="small text-muted">Visits</span>
            </a>
        </div>

    </div>
</div>
<div class="container-fluid text-end px-0">
    <button id="chartListBtn" class="btn btn-sm btn-danger ms-auto" data-bs-toggle="collapse" data-bs-target="#chartList">Hide</button>
</div>

<div class="container-fluid container-lg table-responsive position-relative">
    <?php if ( $chart === 'attachments' ) { include "template/attachments-interval.php"; } ?>
    <h4><?php echo $chartTitle; ?></h4>
    <canvas id="chartCanvas" class="table"></canvas>
</div>

<div id="dataModal" class="modal" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <div class="d-block">
                    <h5 id="dataModalTitle" class="modal-title">Data</h5>
                    <!-- <small class="text-muted">Showing last 100 actions</small> -->
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div id="dataModalBody" class="modal-body px-0">
                
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<?php include 'layout/footer.php'; ?>