$(document).ready(function() {
    $(document).on('click', '.sendTokenButton', function(e) {
        $('#sendTokenModalBody').html(loader);

        var id = $(this).data('id');

        $.ajax({
            url: '/clients/admin/ajax/send-token-form.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#sendTokenModalBody').html(data);
                $('.selectpicker').selectpicker();
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    $(document).on('click', '.viewClientLogsButton', function(e) {
        $('#clientLogsModalBody').html(loader);

        var id = $(this).data('id');

        $.ajax({
            url: '/clients/admin/ajax/view-client-logs.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#clientLogsModalBody').html(data);
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    new DataTable('#clientsDT', {
        // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
        layout: {
            topStart: {
                pageLength: {
                    menu: [10, 25, 50, 100],
                    text: '_MENU_'
                }
            },
            topEnd: {
                search: {
                    text: '',
                    placeholder: 'Search'
                }
            },
            bottomStart: null
        },
        pageLength: 50,
        // scrollX: true,
        // fixedColumns: true,
        // order: [[2, 'asc']]
    });
});