var dzSelections = {
    init: function() {
        let selectionResultHtml = $('#selectionResultArea').html();

        this.on('addedfile', function(file, response) {
            $('#addPlans').hide();
            let ext = file.name.split('.').pop();
            if ( ext == 'pdf' || ext == 'PDF' ) {
                $(file.previewElement).find(".dz-details img").attr("src", "/clients/assets/images/pdf-icon.png").css('width', '120px').css('height', '120px');
            }
        });
        this.on("sending", function(file, xhr, formData) {
            $('#selectionResultArea').html(loader);
            formData.append('projectId', $('#newSelectionSheetProjectId').val());
        });
        this.on('success', function(file, response) {
            console.log(response);
            this.removeAllFiles();
            $('#addPlans').show();
            // toastr["success"]("File uploaded", "Success");

            $('#selectionResultArea').html(response);
        });
        this.on('error', function(file, message) {
            // console.log(message);
            // toastr["error"](message, "Error");
            $('#selectionResultArea').html(selectionResultHtml);
        });
        this.on('reset', function() {
            $('#addPlans').show();
        });
    }, 
    url: "/clients/admin/ajax/new-selection-sheet.php",
    // addRemoveLinks: true,
    autoProcessQueue: true,
    uploadMultiple: false,
    acceptedFiles: 'application/pdf',
    parallelUploads: 1,
    maxFilesize: 30,
    maxFiles: 1,
    previewTemplate: '<div class="dz-preview dz-file-preview text-center me-2"><div class="dz-details"><img data-dz-thumbnail /></div><div class="dz-filename"><span data-dz-name></span></div><div class="dz-progress"><span class="dz-upload" data-dz-uploadprogress></span></div><div class="dz-error-message"><span data-dz-errormessage></span></div><a class="text-danger" href="javascript:undefined;" data-dz-remove>Remove</a></div>',
}

function initSelectionsDropzone() {
    return new Dropzone("div#selectionsDropzone", dzSelections);
}

$(document).ready(function() {
    $(document).on('click', '.editProjectButton', function(e) {
        $('#editProjectModalBody').html(loader);

        var id = $(this).data('id');

        $.ajax({
            url: '/clients/admin/ajax/edit-project-form.php',
            method: 'POST',
            dataType: 'html',
            data: {
                id: id
            },
            success: function (data) {
                // console.log(data);
                $('#editProjectModalBody').html(data);
                $('.selectpicker').selectpicker();

                $.ajax({
                    url: '/clients/admin/ajax/fetch-task-lists.php',
                    method: 'POST',
                    success: function (data) {
                        // console.log(data);
                        $('#editProjectTaskListSelect').html(data);
                        $('#editProjectTaskListLoader').html('<i class="bi bi-check text-success"></i>');

                        let sheetId = $('#editProjectTaskListSelect').data('id');
                        if ( sheetId ) {
                            $('#editProjectTaskListSelect').val(sheetId);
                        }
                    },
                    error: function (e) {
                    }
                });
            },
            error: function (e) {
                // var error = e.responseJSON.error;
                // console.log(error);
            }
        });
    });

    $(document).on('click', '.newSelectionSheetButton', function(e) {
        var id = $(this).data('id');
        $('#newSelectionSheetProjectId').val(id);
    });

    $(document).on('click', '#selectionNewGroup', function(e) {
        let html = '<div class="row align-items-center my-1"><div class="col-1 d-flex justify-content-center"><div class="form-check"><input class="form-check-input" type="checkbox" value="" checked></div></div><div class="col-11"><input type="text" value="New group" class="form-control selectionGroup"></div></div>';
        $('#newGroupContainer').prepend(html);
        $('.selectionGroup').first().select();
    });

    $(document).on('click', '#selectionCollapseAll', function(e) {
        $('.collapse').removeClass('show');
    });

    $(document).on('click', '#selectionExpandAll', function(e) {
        $('.collapse').addClass('show');
    });

    $(document).on('click', '.uncheckAll', function(e) {
        let group = $(this).data('group');
        $('.selectionGroupDefaults-'+group).prop('checked', false); 
    });

    $(document).on('click', '.checkAll', function(e) {
        let group = $(this).data('group');
        $('.selectionGroupDefaults-'+group).prop('checked', true); 
    });

    new DataTable('#projectsDT', {
        // dom: '<"d-flex justify-content-between my-2"<"d-flex me-auto"l><"d-flex ms-auto"f>>',
        layout: {
            topStart: {
                pageLength: {
                    menu: [10, 25, 50, 100],
                    text: '_MENU_'
                }
            },
            topEnd: {
                search: {
                    text: '',
                    placeholder: 'Search'
                }
            },
            bottomStart: null
        },
        pageLength: 50,
        // scrollX: true,
        // fixedColumns: true,
        // order: [[2, 'asc']]
    });

    const selectionsDz = initSelectionsDropzone();
});