<?php 
    session_start();
    if ( isset($_SESSION['error']) ) {
        $error = $_SESSION['error'];
        unset($_SESSION['error']);
    } else {
        $error = false;
    }

    include 'src/load-projects.php';
    include 'layout/header.php'; 
?>

<style>
    .avatar-text {
        width: 35px;
        height: 35px;
        border-radius: 50%;
        border: 2px solid white;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
    }
</style>

<div class="container-fluid p-3">
    <div class="d-flex justify-content-between mb-3">
        <div class="d-flex">
            <h1>Dashboard</h1>
        </div>

        <?php if ( $error ) : ?>
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                <?php echo $error; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

    </div>
    <div class="row">
        <?php 
            foreach ( $userProjects as $project ) : 
                $pdo                = $db->getPdo();
                // $stmt               = $pdo->prepare("SELECT client.id, client.userId, client.email, client.name, client.createdBy, client.createdAt FROM client, client_project WHERE client_project.projectId = ? AND client_project.clientId = client.id;");
                $stmt               = $pdo->prepare("SELECT client.id, client.userId, client.email, client.observer, client.createdBy, client.createdAt, user.name FROM client, client_project, user WHERE client_project.projectId = ? AND client_project.clientId = client.id AND client.userId = user.id;");
                $exec               = $stmt->execute([$project['id']]);
                $project['clients'] = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                $names = implode(', ', array_column($project['clients'], 'name'));
                // var_dump($project['clients']);

                $attachment = $db->row("SELECT * FROM attachment WHERE projectId = ? AND (mimeType = 'image/jpeg' OR mimeType = 'image/png') ORDER BY createdAt DESC LIMIT 0,1", $project['id']);

                $src = URL_ATTACHMENTS."/$attachment[pathname]";
                if ( file_exists(PATH_ATTACHMENTS."/small/$attachment[pathname]") ) {
                    $src = URL_ATTACHMENTS."/small/$attachment[pathname]";
                }
                if ( file_exists(PATH_ATTACHMENTS."/thumbs/$attachment[pathname]") ) {
                    $src = URL_ATTACHMENTS."/thumbs/$attachment[pathname]";
                }

                // $project['city'] = $db->cell("SELECT city FROM weather WHERE projectId = ? ORDER BY date DESC LIMIT 0,1", $project['id']);
        ?>
            <div class="col-lg-4 col-xl-3 mb-5">
                <div class="card border shadow h-100">
                    <?php if ( $attachment ) : ?>
                        <a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>"><img src="<?php echo $src; ?>" class="card-img-top" alt="Latest Project Image"></a>
                    <?php endif; ?>
                    <div class="card-body d-flex flex-column">
                        <div class="d-flex justify-content-between">
                            <div class="d-block text-start">
                                <h5 class="card-title mb-0">
                                    <a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>" class="text-danger"><?php echo $project['title']; ?> Project</a>
                                </h5>
                                <small class="text-muted">Started <?php echo time_elapsed_string($project['createdAt']); ?></small>
                            </div>
                            <div class="d-block text-end">
                                <?php if ( $project['city'] ) : ?><small class="text-muted"><?php echo $project['city']; ?>, <?php echo COMPANY_STATE_ABBR; ?></small><?php endif; ?>
                                <br>
                                <?php // if ( $weather['lat'] && $weather['lon'] ) : ?><!--<small class="text-muted">(<?php // echo $weather['lat']; ?>, <?php // echo $weather['lon']; ?>)</small> --><?php // endif; ?>
                            </div>
                        </div>
                        <hr class="my-2">
                        <ol>
                            <?php 
                                foreach ( $project['clients'] as $client ) :
                                    if ( $client['observer'] ) {
                                        continue;
                                    }
                            ?>
                                        <li><?php echo $client['name']; ?><br><small class="text-muted"><?php echo $client['email']; ?></small></li>
                            <?php
                                endforeach; 
                            ?>
                        </ol>
                        <div class="d-grid mt-auto">
                            <a type="button" class="btn btn-block btn-danger" href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>">View</a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<?php include 'layout/footer.php'; ?>