<?php
$projectId = $_POST['projectId'];
$date      = $_POST['date'];
$project   = $db->row("SELECT * FROM project WHERE id = ?", $projectId);
$zip       = $project['zip'];

if ( !$weather = $db->row("SELECT * FROM weather WHERE projectId = ? AND date = ?", $projectId, $date) ) {
    $weather = [];

    //get lat lon
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "http://api.openweathermap.org/geo/1.0/zip?zip=$zip,US&limit=1&appid=".OWM_API_TOKEN);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json, Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = json_decode(curl_exec($ch));
    curl_close($ch);

    // echo "<pre>";
    // print_r($response);
    // echo "</pre>";

    $weather['lat']  = $response->lat;
    $lat             = $weather['lat'];
    $weather['lon']  = $response->lon;
    $lon             = $weather['lon'];
    $weather['city'] = $response->name;

    $time = strtotime("$date + 8 hours");

    //get aggregate weather for a timestamp
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.openweathermap.org/data/3.0/onecall/timemachine?lat=$lat&lon=$lon&dt=$time&units=imperial&appid=".OWM_API_TOKEN);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json, Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = json_decode(curl_exec($ch));
    curl_close($ch);

    // echo "<pre>";
    // print_r($response);
    // echo "</pre>";

    $weather['icon']        = str_replace('n', 'd', $response->data[0]->weather[0]->icon);
    $weather['description'] = $response->data[0]->weather[0]->description;

    //get daily summary for a date
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.openweathermap.org/data/3.0/onecall/day_summary?lat=$lat&lon=$lon&date=$date&units=imperial&appid=".OWM_API_TOKEN);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json, Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = json_decode(curl_exec($ch));
    curl_close($ch);

    // echo "<pre>";
    // print_r($response);
    // echo "</pre>";

    $weather['min']           = round($response->temperature->min);
    $weather['max']           = round($response->temperature->max);
    $weather['windSpeed']     = round($response->wind->max->speed);
    $weather['windDirection'] = $response->wind->max->direction;
    $weather['precipitation'] = round($response->precipitation->total);

    // echo "<pre>";
    // print_r($day);
    // echo "</pre>";

    //store weather data
    $db->insert('weather', [
        'projectId'     => $projectId,
        'sheetId'       => $project['sheetId'],
        'min'           => $weather['min'],
        'max'           => $weather['max'],
        'windSpeed'     => $weather['windSpeed'],
        'windDirection' => $weather['windDirection'],
        'precipitation' => $weather['precipitation'],
        'description'   => $weather['description'],
        'icon'          => $weather['icon'],
        'city'          => $weather['city'],
        'lat'           => $weather['lat'],
        'lon'           => $weather['lon'],
        'time'          => $time,
        'date'          => $date
    ]);
}

$city = $project['city'];
include '../template/weather-social.php';