<?php
    if ( count($logs) < 1 ) :
        // $lat = $latlon['lat'];
        // $lon = $latlon['lon'];
?>
        <p>No logs for this date</p>
<?php
        exit;
    endif;
    foreach ( $logs as $log ) : 
        $dt = new DateTime($log['createdAt'], new DateTimeZone('UTC'));
        $dt->setTimezone(new DateTimeZone('America/New_York'));

        $datetime = $dt->format('Y-m-d H:i:s');
        $time     = $dt->format('g:i a');
        $timestamp = strtotime($log['createdAt']);
        // echo "<pre>";
        // print_r($log);
        // echo "</pre>";
?>

<div data-id="<?php echo $log['id']; ?>" data-time="<?php echo $timestamp; ?>" data-project="<?php echo $log['projectId'] ?>" class="dailyLog">
    <div class="d-flex justify-content-between align-items-center">
        <!-- <div class="d-block"> -->
        <div class="d-flex align-items-center">
<?php
            if ( !file_exists(PATH_ASSETS.'/images/avatar/'.$log['createdByName'].'.jpg')) :
                $parts    = explode(' ', $log['createdByName']);
                $initials = substr($parts[0], 0, 1) . substr(end($parts), 0, 1);
?>
                <div class="initial-avatar" alt="<?php echo $log['createdByName']; ?>" title="<?php echo $log['createdByName']; ?>"><?php echo $initials; ?></div>
<?php
            else :
?>
                <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $log['createdByName']; ?>.jpg" alt="<?php echo $log['createdByName']; ?>" title="<?php echo $log['createdByName']; ?>" class="avatar-small">
<?php
            endif;
?>
            <!-- <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $log['createdByName'] ?>.jpg" alt="Avatar" class="avatar-small"> -->
            <strong class="ms-2"><?php echo $log['createdByName']; ?></strong>
        </div>
        <div class="d-block text-end">
            <small class="text-muted"><?php echo $time; ?></small>
            <br>
            <small class="text-muted">(<?php echo time_elapsed_string($datetime); ?>)</small>
        </div>
    </div>
    <p class="mt-2"><?php echo nl2br(htmlspecialchars($log['text']));  ?></p>
    <div class="d-flex justify-content-start">
        <div class="row">
            <?php
                foreach ( $log['attachments'] as $attachment ) {
                    $sheetId      = $log['sheetId'];
                    $attachmentId = $attachment['id'];
                    include 'daily-log-attachment.php';
                }
            ?>
            </div>
        </div>
    </div>
    <div id="<?php echo $timestamp; ?>" class="d-flex">
        <div class="d-flex justify-content-center align-items-center">
            <div class="spinner-border text-danger" role="status">
            </div>
            <span class="ms-2">Loading weather...</span>
        </div>
    </div>
</div>

<hr class="my-3">

<?php endforeach; ?>