<?php ob_start(); ?>
    <div id="forecast-8d" class="row gx-2">
        <?php foreach ( $days as $day ) : ?>
            <div class="col-6 mb-2">
                <div class="border rounded p-2">
                    <div class="text-center forecast-day">
                        <strong><?php echo date('D, M j', $day->dt); ?></strong>
                        <br>
                        <img src="<?php echo URL_ASSETS; ?>/images/weather/<?php echo $day->weather[0]->icon; ?>@2x.png" width="100px;" >
                        <br>
                        <?php echo round($day->temp->min); ?>&deg;F / <?php echo round($day->temp->max); ?>&deg;F
                        <br>
                        <small><span class="text-muted"><?php echo $day->weather[0]->description; ?></span></small>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    <div id="forecast-48h" class="row gx-2 d-none">
        <?php foreach ( $hours as $hour ) : ?>
            <div class="col-6 mb-2">
                <div class="border rounded p-2">
                    <div class="text-center forecast-day">
                        <strong><?php echo date('ga', $hour->dt); ?></strong>
                        <br>
                        <img src="<?php echo URL_ASSETS; ?>/images/weather/<?php echo $hour->weather[0]->icon; ?>@2x.png" width="100px;" >
                        <br>
                        <?php echo round($hour->temp); ?>&deg;F
                        <br>
                        <span class="text-muted small text-nowrap"><?php echo $hour->weather[0]->description; ?></span>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php
    $html = ob_get_clean();
    $data = json_encode(['lat' => $lat, 'lon' => $lon]);
    $forecastResponse = ['html' => $html, 'data' => $data];
    echo json_encode($forecastResponse);
?>