<?php ob_start(); ?>
<div id="forecast-8d" class="forecast-container hstack justify-content-between overflow-x-scroll gap-5 p-3 px-md-5 border border-start-0 border-end-0">
    <?php foreach ( $days as $day ) : ?>
        <div class="text-center forecast-day">
            <strong><?php echo date('D, M j', $day->dt); ?></strong>
            <br>
            <img src="<?php echo URL_ASSETS; ?>/images/weather/<?php echo $day->weather[0]->icon; ?>@2x.png" width="100px;" >
            <br>
            <?php echo round($day->temp->min); ?>&deg;F / <?php echo round($day->temp->max); ?>&deg;F
            <br>
            <span class="text-muted small text-nowrap"><?php echo $day->weather[0]->description; ?></span>
        </div>
    <?php endforeach; ?>
</div>
<div id="forecast-48h" class="forecast-container hstack justify-content-between overflow-x-scroll gap-5 p-3 px-md-5 border border-start-0 border-end-0 d-none">
    <?php foreach ( $hours as $hour ) : ?>
        <div class="text-center forecast-day">
            <strong><?php echo date('ga', $hour->dt); ?></strong>
            <br>
            <img src="<?php echo URL_ASSETS; ?>/images/weather/<?php echo $hour->weather[0]->icon; ?>@2x.png" width="100px;" >
            <br>
            <?php echo round($hour->temp); ?>&deg;F
            <br>
            <span class="text-muted small text-nowrap"><?php echo $hour->weather[0]->description; ?></span>
        </div>
    <?php endforeach; ?>
</div>
<?php
    $html = ob_get_clean();
    $data = json_encode(['lat' => $lat, 'lon' => $lon]);
    $forecastResponse = ['html' => $html, 'data' => $data];
    echo json_encode($forecastResponse);
?>