<?php
if ( !isset($_POST['groupId']) ) {
    http_response_code(400);
    echo json_encode('No group ID');
    exit;
}

if ( !$group = $db->row("SELECT * FROM selection_group WHERE id = ?", $_POST['groupId']) ) {
    http_response_code(400);
    echo json_encode('Invalid group ID');
    exit;
}

if ( !$user['superAdmin'] ) {
    if ( !$exists = $db->cell("SELECT id FROM client_project WHERE clientId = ? AND projectId = ?", $user['client']['id'], $group['projectId']) ) {
        http_response_code(403);
        echo json_encode('You do not have permission to edit this selection group');
        exit;
    }
}
?>

<!-- <form id="editGroupForm" method="POST" action="<?php echo URL_APP; ?>/selections/src/edit-group.php"> -->
    <div class="form-floating mb-2">
        <input id="selectionGroupTitle" type="text" name="title" class="form-control" required value="<?php echo $group['title']; ?>">
        <label for="title">Title</label>
    </div>
    <div class="form-floating mb-2">
        <textarea id="selectionGroupDescription" name="description" class="form-control" style="height:200px;"><?php echo $group['description']; ?></textarea>
        <label for="description">Description</label>
    </div>
    <input type="hidden" name="groupId" value="<?php echo $group['id']; ?>">
    <!-- <input type="hidden" name="projectId" class="form-control" value="<?php //echo $group['projectId']; ?>"> -->
<!-- </form> -->