<?php 
    //projectId needs to be set, or we can't load
    if ( !isset($_GET['projectId']) ) {
        session_start();
        $_SESSION['error'] = 'No project ID';

        header('Location: '.URL_APP.'/dashboard');
        exit;
    } 

    $pid = $_GET['projectId'];
    
    //check if user is an admin. if not, check if they are assigned to this project
    if ( !$user['admin'] ) {
        if ( !$exists = $db->cell("SELECT id FROM client_project WHERE clientId = ? AND projectId = ?", $user['client']['id'], $pid) ) {
            session_start();
            $_SESSION['error'] = "You don't have permission to view that project";

            header('Location: '.URL_APP.'/dashboard');
            exit;
        }
    } else {
        //load all projects for admins
        include '../project/src/admin-load-projects.php';
    }

    $userProject = $db->row("SELECT * FROM project WHERE id = ?", $pid);
    $userLikes   = array_column($db->run("SELECT thumb.commentId FROM thumb WHERE thumb.userId = ?", $user['id']), 'commentId');
    
    session_start();
    if ( isset($_SESSION['error']) ) {
        $error = $_SESSION['error'];
        unset($_SESSION['error']);
    } else {
        $error = false;
    }

    $view = $_GET['view'] ?? $_COOKIE['btbSelectionView'] ?? 'r';
    $show = $_GET['show'] ?? $_COOKIE['btbSelectionShow'] ?? 'a';
    // $allowed = ( $user['admin'] )
    //     ? 1
    //     : $db->cell("SELECT social FROM client WHERE userId = ?", $user['id'])
    // ;

    setcookie('btbSelectionView', $view, time() + (60*60*24*30*12), '/clients/selections', URL_COOKIES);
    setcookie('btbSelectionShow', $show, time() + (60*60*24*30*12), '/clients/selections', URL_COOKIES);

    include 'src/load-selections.php';
    include 'layout/header.php';
?>

<style>
</style>

<?php include 'template/toolbar.php'; ?>
    
<?php if ( $error ) : ?>
    <div class="container-fluid container-lg mt-5">
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <?php echo $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
<?php endif; ?>

<div id="selectionGroupContainer" class="container">
<?php
    if ( $groups ) {
        include 'template/selection-groups.php';
    } else {
?>
        <div class="d-flex align-items-center justify-content-center text-center">
            <div class="card rounded-4 bg-light-subtle">
                <div class="card-body">
                    <h3>No Selections</h3>
                    <p class="lead">Manually create a new group of selections, or upload a plan to automatically create groups.</p>
                    <div class="hstack gap-2 justify-content-center">
                        <button class="btn btn-sm btn-danger btbAction" type="button" data-action="click" data-target="new default group" data-bs-toggle="modal" data-bs-target="#selectionsNewGroupModal" title="New group">
                            New group<i class="bi bi-plus"></i>
                        </button>
                        <!-- <button class="btn btn-sm btn-danger btbAction" type="button" data-action="click" data-target="new groups from plan" data-bs-toggle="modal" data-bs-target="#selectionsNewGroupsFromPlanModal" title="New groups from plan">
                            Add plans <i class="bi bi-plus"></i>
                        </button> -->
                    </div>
                </div>
            </div>
        </div>
<?php
    }
?>
</div>

<input id="projectId" type="hidden" value="<?php echo $userProject['id']; ?>">
<input id="userId" type="hidden" value="<?php echo $user['id']; ?>">
<input id="city" type="hidden" value="<?php echo $userProject['city']; ?>">
<input id="zip" type="hidden" value="<?php echo $userProject['zip']; ?>">
<input id="view" type="hidden" value="<?php echo $view; ?>">

<?php
    include 'template/new-group-modal.php';
    include 'template/new-selection-item-modal.php';
    include 'template/edit-group-modal.php';
    include 'template/edit-selection-item-modal.php';
    include 'template/generate-pdf-modal.php';
    include 'layout/footer.php';