<div id="editSelectionItemModal" class="modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content" id="editSelectionItemModalContent">
            <form id="editSelectionItemForm" method="POST" action="<?php echo URL_APP; ?>/selections/src/edit-selection-item.php">
                <div class="modal-header">
                    <h5 id="editSelectionItemModalTitle" class="modal-title">Edit Selection Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="editSelectionItemModalBody">
                    <div id="editSelectionItemWrapper">
                        <div id="editSelectionItemDropzoneContainer" class="mb-2 d-none">
                            <div id="editSelectionItemDropzone" class="d-flex justify-content-center align-items-center rounded overflow-x-scroll" style="border:1px grey dashed;min-height:200px;cursor:pointer;">
                                <div id="uploadEditSelectionItemImage" class="text-center">
                                    <div class="fw-bold">Add Image</div>
                                </div>
                            </div>
                            <div class="small mt-1 ms-1">
                                <span class="text-muted">Drag and drop or click inside the box to upload files</span>
                                <br> 
                                <span class="text-muted">Max number of files:</span> 1
                                <br>
                                <span class="text-muted">Max size per file:</span> 30MB
                                <br>
                                <span class="text-muted">Max total upload size:</span> 30MB 
                                <br>
                                <span class="text-muted">Accepted file types:</span> JPG/JPEG, PNG
                            </div>
                        </div>

                        <div id="editSelectionItemImageContainer" class="mb-2">
                            <div class="d-flex justify-content-between px-2 pb-1">
                                <span class="small text-muted">Image</span>
                                <button id="removeEditSelectionItemImageButton" type="button" class="btn-close" data-bs-toggle="tooltip" data-bs-title="Remove image"></button>
                            </div>
                            <img id="editSelectionItemImage" class="img-thumbnail" src="<?php echo URL_SELECTION_ATTACHMENTS ?>/<?php echo $selection['image']; ?>">
                        </div>

                        <div class="form-floating mb-2">
                            <input id="editSelectionItemTitle" type="text" name="title" class="form-control" required>
                            <label for="title">Title</label>
                        </div>
                        <div class="form-floating mb-2">
                            <input id="editSelectionItemVendor" type="text" name="vendor" class="form-control">
                            <label for="vendor">Vendor</label>
                        </div>
                        <div class="form-floating mb-2">
                            <textarea id="editSelectionItemDescription" name="description" class="form-control" style="height:200px;"></textarea>
                            <label for="description">Description</label>
                        </div>
                        <div class="mb-2">
                            <select id="editSelectionItemTags" name="tags[]" class="selectpicker my-1" multiple data-live-search="true" title="Select tag(s)" data-selected-text-format="count > 2" data-width="100%">
                                <?php
                                    if ( is_array( $selection['tags'] ) ) :
                                        foreach ( $defaultCategories as $category ) :
                                            $selected = ( in_array($category['id'], $selection['tags']) )
                                                ? "selected"
                                                : ""
                                            ;
                                ?>
                                    <option value="<?php echo $category['id']; ?>" <?php echo $selected; ?>><?php echo $category['title']; ?></option>
                                <?php 
                                        endforeach; 
                                    endif;
                                ?>
                            </select>
                        </div>
                        <div class="form-floating mb-2">
                            <input id="editSelectionItemUnit" type="text" name="unit" class="form-control">
                            <label for="unit">Unit</label>
                        </div>
                        <div class="input-group mb-2">
                            <label class="input-group-text"><i class="bi bi-currency-dollar text-success"></i></label>
                            <div class="form-floating">
                                <input id="editSelectionItemCost" type="number" name="cost" step=".01" class="form-control">
                                <label for="cost">Cost Per Unit</label>
                            </div>
                        </div>
                        <div class="form-floating mb-2">
                            <input id="editSelectionItemQuantity" type="number" name="quantity" class="form-control">
                            <label for="quantity">Quantity</label>
                        </div>
                        <div class="input-group mb-2">
                            <div class="form-floating">
                                <input id="editSelectionItemLink" type="text" name="link" class="form-control">
                                <label for="link">Link</label>
                            </div>
                            <a id="editSelectionItemLinkButton" href="<?php echo $selection['link']; ?>" target="_blank" class="btn btn-danger pt-3" role="button">Go</a>
                        </div>
                        <input id="editSelectionItemFilename" type="hidden" name="editSelectionItemFilename">
                        <input id="editSelectionItemId" type="hidden" name="selectionItemId">
                    </div>
                </div>
                <div class="modal-footer" id="editSelectionItemModalFooter">
                    <?php if ( $selection['createdBy'] === $user['id'] || $user['superAdmin'] ) : ?>
                        <a id="deleteSelectionItemButton" href="<?php echo URL_APP; ?>/selections/src/delete-selection-item.php?itemId=<?php echo $selection['id']; ?>" onclick="return confirm('Are you absolutely sure you want to delete this item? This cannot be undone.')" type="button" class="btn btn-warning me-auto">Delete</a>
                    <?php endif; ?>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button id="saveEditSelectionItemButton" type="submit" class="btn btn-danger">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>  