<!doctype html>
<html lang="en" data-bs-theme="">
<head>
    <meta charset="utf-8">
    <!-- <meta name="viewport" content="user-scalable=no, width=device-width, initial-scale=1"> -->

    <title>Project - <?php echo COMPANY_NAME; ?> Client Portal</title>

    <link href="<?php echo URL_ASSETS; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo URL_ASSETS; ?>/icons/bootstrap-icons.css" rel="stylesheet">
    
    <style>
        @page {
            size: letter;
        }

        /* @media print { */
            .centerprint {
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
                text-align: center;
                width: 100%;
                /* height: 100vh; */
                /* max-height: 1080px; */
                height: 900px;
            }
        /* } */

        .page-header, .page-footer {
            font-size: 7pt;
            font-style: italic;
        }

        .label {
            font-size: 8pt;
        }
    </style>
</head>

<body>






    <?php if ( $_POST['optionShowCoverPage'] ) : ?>
    <div id="coverpage" class="coverpage centerprint" style="page-break-after:always;">
        <h1><?php echo $project['title']; ?> Project Finish Schedule</h1>
        <img src="<?php echo URL_ASSETS; ?>/images/btb-logo.png" style="max-width:350px;">
    </div>
    <?php endif; ?>

    <?php 
        foreach ( $groups as $group ) :
            // if ( count($group['selections']) < 1 )
            //     continue;
    ?>
        <div id="group<?php echo $group['id']; ?>" class="group" style="page-break-after:always;">

            <div class="page-header d-flex align-items-center justify-content-between">
                <span><?php echo $project['title']; ?> Project Finish Schedule</span>
                <!-- <span><?php // echo htmlspecialchars($group['title']); ?></span> -->
                 <img src="<?php echo URL_ASSETS; ?>/images/btb-logo.png" style="max-width:120px;">
            </div>

            <hr>

            <div class="row g-0 align-items-center">
                <div class="col-10">
                    <h6 class="mb-0"><?php echo htmlspecialchars($group['title']); ?></h6>
                    <?php if ( $_POST['optionShowGroupDescription'] ) : ?>
                        <div class="small"><?php echo htmlspecialchars($group['description']); ?></div>
                    <?php endif; ?>
                </div>
                <div class="col-2">
                    <div class="small text-end">
                        <div><?php echo count($group['selections']); ?> item(s)</div>
                        <?php if ( $_POST['optionShowGroupTotalCost'] ) : ?><div class="fw-bold text-success">$<?php echo number_format($group['sum'], 2); ?></div><?php endif; ?>
                    </div>
                </div>
            </div>

            <hr>

            <?php
                $i = 1;
                foreach ( $group['selections'] as $selection ) :
                    // echo "<pre>";
                    // print_r($selection);
                    // echo "</pre>";
            ?>
                <div class="row g-0 align-items-center item" style="page-break-inside:avoid;">
                    <div class="col-2">
                        <?php if ( $_POST['optionShowItemImage'] ) : ?>
                            <?php if ( $selection['image'] ) : ?>
                                <img class="rounded-4" src="<?php echo URL_SELECTION_ATTACHMENTS; ?>/<?php echo htmlspecialchars($selection['image']); ?>" alt="<?php echo htmlspecialchars($selection['title']); ?>" title="<?php echo htmlspecialchars($selection['title']); ?>" style="width:80px;height:80px;object-fit:cover;">
                            <?php else : ?>
                                <img class="rounded-4" src="<?php echo URL_ASSETS; ?>/images/btb-logo-abbr-trans.png" alt="No selection image" title="No selection image" style="width:80px;height:80px;object-fit:cover;">
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <div class="col-8">
                        <div>
                            <div class="hstack gap-1 align-items-center mb-1">
                            <?php foreach ( $selection['tags'] as $tag ) : ?>
                                <span class="badge rounded-pill text-bg-danger"><?php echo $tag['title']; ?></span>
                            <?php endforeach; ?>
                            </div>
                        </div>
                        <div class="small">
                            <?php echo $i; ?>. <span class="fw-bold"><?php echo htmlspecialchars($selection['title']); ?></span>
                            <?php if ( $_POST['optionShowItemVendor'] ) : ?>
                                - <em><?php echo htmlspecialchars($selection['vendor']); ?></em>
                            <?php endif; ?>
                        </div>
                        <?php if ( $_POST['optionShowItemDescription'] ) : ?>
                                <div class="small"><?php echo substr(nl2br(htmlspecialchars($selection['description'])), 0, 325); ?> <?php if ( strlen($selection['description']) > 325 ) : ?>...<?php endif; ?></div>
                                <!--<div class="small"><?php echo nl2br(htmlspecialchars($selection['description'])); ?></div>-->
                        <?php endif; ?>
                    </div>
                    <div class="col-2">
                        <div class="small text-end text-nowrap">
                            <?php if ( $_POST['optionShowItemCostPer'] ) : ?>
                                 <div><span class="label">Cost: </span><span class="fw-bold text-success">$<?php echo number_format($selection['cost'], 2); ?></span></div>
                            <?php endif; ?>
                            <?php if ( $_POST['optionShowItemUnit'] ) : ?>
                                 <div><span class="label">Unit: </span><span class="fw-bold"><?php echo htmlspecialchars($selection['unit']); ?></span></div>
                            <?php endif; ?>
                            <?php if ( $_POST['optionShowItemQuantity'] ) : ?>
                                <div><span class="label">Qty: </span><span class="fw-bold"><?php echo htmlspecialchars($selection['quantity']) ?? 0; ?></span></div>
                            <?php endif; ?>
                            <?php if ( $selection['quantity'] > 0 ) : ?>
                                <?php if ( $_POST['optionShowItemTotalCost'] ) : ?>
                                    <hr class="my-1">
                                    <div><span class="label">Total: </span><span class="fw-bold text-success">$<?php echo number_format($selection['quantity'] * $selection['cost'], 2); ?></span></div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <hr>
            <?php
                    $i++;
                endforeach;
            ?>
            <div class="page-footer d-flex align-items-center justify-content-between">
                <span><?php echo $project['title']; ?> Project Finish Schedule</span>
                <span><?php echo htmlspecialchars($group['title']); ?></span>
            </div>
        </div>
    <?php
        endforeach;
    ?>

    <script src="<?php echo URL_ASSETS; ?>/js/bootstrap.bundle.min.js"></script> 
    <script src="<?php echo URL_ASSETS; ?>/js/jquery.js"></script>
</body>
</html>