<?php
    if ( $selection['selectionImage'] ) {
        $baseSrc  = URL_SELECTION_ATTACHMENTS;
        $basePath = PATH_SELECTION_ATTACHMENTS;

        $link = "$baseSrc/$selection[selectionImage]";
        $dl   = $link;
        $src  = $link;
        if ( file_exists("$basePath/small/$selection[selectionImage]") ) {
            $link = "$baseSrc/small/$selection[selectionImage]";
            $src  = $link;
        }
        if ( file_exists("$basePath/thumbs/$selection[selectionImage]") ) {
            $src = "$baseSrc/thumbs/$selection[selectionImage]";
        }
    } else {
        $link = URL_ASSETS.'/images/no-selection.png';
        $dl   = $link;
        $src  = $link;
    }

    $padding = ( $selection['selected'] )
        ? '0'
        : '60px'
    ;

    if ( $selection['selected'] ) {
        $status = 'Selected';
        $statusClass = 'text-success';
    } else {
        $status = 'Needs Selection';
        $statusClass = 'text-warning';
    }
    if ( $selection['priority'] ) {
        $status = 'Priority - Select ASAP';
        $statusClass = 'text-danger fw-bold';
    }

    if ( $selection['vendor'] ) {
        $vendor = $selection['vendor'];
    } else {
        $vendor = false;
    }
    
?>
<div class="text-center">
    <a href="<?php echo $link; ?>" data-fancybox="btb-selection-<?php echo $selection['id']; ?>" data-download-src="<?php echo $dl; ?>">
        <img 
        data-src="<?php echo $src; ?>" 
        alt="<?php echo $userProject['title'] ?>" 
        class="lazy img-fluid w-100"
        >
    </a>
</div>
<div class="modal-body">
    <p class="fw-bold"><?php echo $selection['title']; ?></p>
    <p class=""><?php echo nl2br($selection['description']); ?></p>
    <hr>
    <div class="d-flex justify-content-between">
        <span class="small text-muted">Room</span>
        <a href="<?php echo URL_SELECTION_ATTACHMENTS; ?>/<?php echo $selection['roomImage']; ?>" data-fancybox="btb-selection-room-image" data-download-src="<?php echo URL_SELECTION_ATTACHMENTS; ?>/<?php echo $selection['roomImage']; ?>" class="text-danger">
            <?php echo $selection['room']; ?>
        </a>
    </div>
    <div class="d-flex justify-content-between">
        <span class="small text-muted">Level</span>
        <span class=""><?php echo $selection['level']; ?></span>
    </div>
    <div class="d-flex justify-content-between">
        <span class="small text-muted">Type</span>
        <span class=""><?php echo $selection['type']; ?></span>
    </div>
    <div class="d-flex justify-content-between">
        <span class="small text-muted">Category</span>
        <span class=""><?php echo $selection['category']; ?></span>
    </div>
    <div class="d-flex justify-content-between">
        <span class="small text-muted">Status</span>
        <span class="<?php echo $statusClass; ?>"><?php echo $status; ?></span>
    </div>
    <?php if ( $vendor ) : ?>
        <div class="d-flex justify-content-between">
            <span class="small text-muted">Vendor</span>
            <?php if ( $selection['link'] ) : ?>
                <a href="<?php echo $selection['link']; ?>" target="_blank" class="text-danger"><?php echo $vendor; ?></a>
            <?php else : ?>
                <span class=""><?php echo $vendor; ?></span>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>