<div class="container">
    <pre><?php //print_r($projectSelections); ?></pre>
    <pre><?php //print_r($selections); ?></pre>
    <pre><?php //print_r($rooms); ?></pre>
    <pre><?php //print_r($counts); ?></pre>
</div>

<div class="container">

<?php 
foreach ( $rooms as $room ) :
    if ( empty($selections[$room]) ) {
        continue;
    }
?>
<div class="card rounded-4 bg-light-subtle mb-3">
    <div class="card-body">
        <div class="row">
            <div class="col-12 col-md-4 col-lg-4 mb-4">
            <div class="d-flex align-items-center justify-content-between border rounded-4 shadow bg-body p-3">
                    <div class="d-block">
                        <h5 class="mb-0"><?php echo $room; ?></h5>
                        <div class="small text-muted"><?php echo $selections[$room][0]['level']; ?> Level <?php echo $selections[$room][0]['type']; ?></div>
                    </div>
                    <a href="<?php echo URL_SELECTION_ATTACHMENTS; ?>/<?php echo $selections[$room][0]['roomImage']; ?>" data-fancybox="btb-selection-rooms" data-download-src="<?php echo URL_SELECTION_ATTACHMENTS; ?>/<?php echo $selections[$room][0]['roomImage']; ?>">
                        <img 
                            data-src="<?php echo URL_SELECTION_ATTACHMENTS; ?>/<?php echo $selections[$room][0]['roomImage']; ?>" 
                            alt="<?php echo $room; ?>" 
                            class="lazy img-thumbnail object-fit-cover rounded-4"
                            style="width:50px;height:50px;"
                        >
                    </a>
                </div>
            </div>
            <?php 
                foreach ( $selections[$room] as $selection ) : 
                    if ( $selection['selectionImage'] ) {
                        $baseSrc  = URL_SELECTION_ATTACHMENTS;
                        $basePath = PATH_SELECTION_ATTACHMENTS;
            
                        $link = "$baseSrc/$selection[selectionImage]";
                        $dl   = $link;
                        $src  = $link;
                        if ( file_exists("$basePath/small/$selection[selectionImage]") ) {
                            $link = "$baseSrc/small/$selection[selectionImage]";
                            $src  = $link;
                        }
                        if ( file_exists("$basePath/thumbs/$selection[selectionImage]") ) {
                            $src = "$baseSrc/thumbs/$selection[selectionImage]";
                        }
                    } else {
                        $link = URL_ASSETS.'/images/no-selection.png';
                        $dl   = $link;
                        $src  = $link;
                    }

                    $badgeClass = ( $selection['selected'] )
                        ? 'text-bg-success'
                        : 'text-bg-warning'
                    ;
                    $badgeIcon = ( $selection['selected'] )
                        ? '<i class="bi bi-check"></i>'
                        : '<i class="bi bi-x"></i>'
                    ;
                    $badgeTooltip = ( $selection['selected'] )
                        ? 'Selected'
                        : 'Needs Selection'
                    ;

                    if ( $selection['priority'] && !$selection['selected'] ) {
                        $badgeClass = 'text-bg-danger';
                        $badgeIcon = '<i class="bi bi-exclamation"></i>';
                        $badgeTooltip = 'Priority - Select ASAP';
                    }

                    $padding = ( $selection['selected'] )
                        ? '0'
                        : '25px'
                    ;
            ?>
            <div class="col-6 col-md-4 col-lg-2 mb-3">
                <div class="text-center position-relative">
                    <a href="" class="selection" data-bs-toggle="modal" data-bs-target="#selectionsModal" data-id="<?php echo $selection['id']; ?>">
                        <img 
                            data-src="<?php echo $src; ?>" 
                            alt="<?php echo $userProject['title'] ?>" 
                            class="lazy img-thumbnail object-fit-cover rounded-4 shadow mb-1"
                            style="width:120px;height:120px;"
                        >
                    </a>
                    <a href="" class="d-block small text-truncate text-danger selection" data-bs-toggle="modal" data-bs-target="#selectionsModal" data-id="<?php echo $selection['id']; ?>"><?php echo $selection['title']; ?></a>
                    <div class="small text-muted text-truncate">
                        <?php if ( $selection['selected'] ) : ?>
                            <?php echo $selection['category']; ?>
                        <?php else : ?>
                            &nbsp;
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endforeach; ?>

<br><br><br><br>

<?php reset($selections); include 'template/selections-table.php'; ?>

</div>