<?php
        $j = 0;
        foreach ( $notifications as $notification ) :
            if ( $j == 0 ) {
?>
                <span id="latestDate" class="visually-hidden"><?php echo $notification['createdAt']; ?></span>
<?php
            }
// echo "<pre>";
// print_r($notification);
// echo "</pre>";
            $updateText   = '';
            $updateStatus = '';
            $avatar       = false;
            $link         = false;
            $displayName  = ( $notification['user']['name'] == $user['name'] )
                ? 'You'
                : $notification['user']['name']
            ;
            $divider = true;
            $class   = '';

            switch ( $notification['objectType'] ) {
                case 'comment' :
                    $avatar = true;
                    $link   = true;
                    switch ( $notification['updateType'] ) {
                        case 'insert' :
                            $updateText = "$displayName posted an update";
                            break;
                        case 'update' :
                            $updateText = "$displayName edited a post";
                            break;
                        case 'delete' :
                            $updateText = "$displayName deleted a post";
                            $link       = false;
                            break;
                    }

                    // if ( in_array($notification['objectId'], $deleted) ) {
                    if ( in_array($notification['id'], $deleted) ) {
                        $link = false;

                        if ( $user['client'] ) {
                            $divider = false;
                            break;
                        }
                    }
?>
                    <?php if ( $link ) : ?>
                        <?php if ( isset($user['client']) && !$user['client']['social'] ) : ?>
                            <a href="<?php echo URL_APP ?>/project/?projectId=<?php echo $notification['project']['id']; ?>#calendar" class="dropdown-item">
                        <?php else : ?>
                            <a href="<?php echo URL_APP ?>/project/?projectId=<?php echo $notification['project']['id']; ?>&view=s&page=<?php echo $notification['page']; ?>#btb-post-<?php echo $notification['objectId']; ?>" class="dropdown-item">
                        <?php endif; ?>
                    <?php else : ?>
                        <li class="dropdown-item">
                    <?php endif; ?>
                            <!-- <p class="small text-muted ms-auto mb-0">New Post</p> -->
                            <div class="d-flex align-items-center">
<?php 
                                if ( $avatar ) {
                                    if ( !file_exists(PATH_ASSETS.'/images/avatar/'.$notification['user']['name'].'.jpg')) {
                                        $parts    = explode(' ', $notification['user']['name']);
                                        $initials = substr($parts[0], 0, 1) . substr(end($parts), 0, 1);
?>
                                        <div class="initial-avatar-notifications flex-shrink-0" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>"><?php echo $initials; ?></div>
<?php
                                    } else {
?>
                                    <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $notification['user']['name']; ?>.jpg" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>" class="avatar-small" style="width:32px;height:32px;">
<?php 
                                    }
                                }
?>
                                <div class="ms-2 w-100" style="min-width:0;">
                                    <span class="d-inline-block text-truncate w-100"><?php echo $updateText; ?></span>
                                    <div class="d-flex justify-content-between">
                                        <span class="small text-muted lh-1"><?php echo $notification['project']['title']; ?> Project</span>
                                        <span class="small text-muted lh-1 ms-auto"><?php echo time_elapsed_string($notification['createdAt']); ?></span>
                                    </div>
                                </div>
                            </div>
                    <?php if ( $link ) : ?>
                        </a>
                    <?php else : ?>
                        </li>
                    <?php endif; ?>
<?php
                    break;
                case 'reply' :
                    if ( isset($user['client']) && !$user['client']['social'] ) {
                        $divider = false;
                        break;
                    }

                    $avatar = true;
                    $link   = true;
                    switch ( $notification['updateType'] ) {
                        case 'insert' :
                            $updateText = "$displayName replied to a post";
                            break;
                        case 'update' :
                            $updateText = "$displayName edited a reply";
                            break;
                        case 'delete' :
                            $updateText = "A reply was deleted";
                            $avatar     = false;
                            $link       = false;
                            break;
                    }

                    if ( in_array($notification['objectId'], $deleted) ) {
                        $link = false;

                        if ( $user['client'] ) {
                            $divider = false;
                            break;
                        }
                    }
?>
                    <?php if ( $link ) : ?>
                        <a href="<?php echo URL_APP ?>/project/?projectId=<?php echo $notification['project']['id']; ?>&view=s&page=<?php echo $notification['page']; ?>#btb-reply-<?php echo $notification['objectId']; ?>" class="dropdown-item">
                    <?php else : ?>
                        <li class="dropdown-item">
                    <?php endif; ?>
                            <!-- <p class="small text-muted ms-auto mb-0">New Post</p> -->
                            <div class="d-flex align-items-center">
<?php 
                                if ( $avatar ) {
                                    if ( !file_exists(PATH_ASSETS.'/images/avatar/'.$notification['user']['name'].'.jpg')) {
                                        $parts    = explode(' ', $notification['user']['name']);
                                        $initials = substr($parts[0], 0, 1) . substr(end($parts), 0, 1);
?>
                                        <div class="initial-avatar-notifications flex-shrink-0" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>"><?php echo $initials; ?></div>
<?php
                                    } else {
?>
                                    <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $notification['user']['name']; ?>.jpg" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>" class="avatar-small" style="width:32px;height:32px;">
<?php 
                                    }
                                }
?>
                                <div class="ms-2 w-100" style="min-width:0;">
                                    <span class="d-inline-block text-truncate w-100"><?php echo $updateText; ?></span>
                                    <div class="d-flex justify-content-between">
                                        <span class="small text-muted lh-1"><?php echo $notification['project']['title']; ?> Project</span>
                                        <span class="small text-muted lh-1 ms-auto"><?php echo time_elapsed_string($notification['createdAt']); ?></span>
                                    </div>
                                </div>
                            </div>
                    <?php if ( $link ) : ?>
                        </a>
                    <?php else : ?>
                        </li>
<?php
                    endif; 
                    break;
                case 'task' :
                    $avatar = true;
                    switch ( $notification['task']['status'] ) {
                        case 'N/A' :
                            $class = "text-bg-secondary";
                            break;
                        case 'Not Started' :
                            $class = "text-bg-danger";
                            break;
                        case 'Negotiating' :
                            $class = "text-bg-primary";
                            break;
                        case 'Scheduled' :
                            $class = "text-bg-info";
                            break;
                        case 'In Progress' :
                            $class = "text-bg-warning";
                            break;
                        case 'Completed' :
                            $class = "text-bg-success";
                            break;
                    }

                    if ( $notification['updateType'] == 'delete' ) {
                        $updateText       = "A task was deleted";
                        $updateStatus     = '';
                        $taskNotification = '';
                    } else {
                        $updateText       = $notification['task']['title'];
                        $updateStatus     = $notification['task']['status'];
                        $link             = true;
                        $taskNotification = 'taskNotification';
                    }

                    if ( ($notification['updateType'] == 'update' || $notification['updateType'] == 'insert') && in_array($notification['objectId'], $deleted) ) {
                        if ( $user['client'] ) {
                            $divider = false;
                            break;
                        }

                        $updateText       = "This task was added/updated but later deleted";
                        $updateStatus     = '';
                        $taskNotification = '';
                        $link             = false;
                    }
?>
                    <?php if ( $link ) : ?>
                        <a href="<?php echo URL_APP ?>/project/?projectId=<?php echo $notification['project']['id']; ?>&view=c#btb-task-<?php echo $notification['objectId']; ?>" class="dropdown-item <?php echo $taskNotification; ?>">
                    <?php else : ?>
                        <li class="dropdown-item <?php echo $taskNotification; ?>">
                    <?php endif; ?>
                            <!-- <p class="small text-muted ms-auto mb-0">Task Status Updated</p> -->
                            <div class="d-flex align-items-center">
<?php
                                if ( $avatar ) {
                                    if ( !file_exists(PATH_ASSETS.'/images/avatar/'.$notification['user']['name'].'.jpg')) {
                                        $parts    = explode(' ', $notification['user']['name']);
                                        $initials = substr($parts[0], 0, 1) . substr(end($parts), 0, 1);
?>
                                        <div class="initial-avatar-notifications flex-shrink-0" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>"><?php echo $initials; ?></div>
<?php
                                    } else {
?>
                                    <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $notification['user']['name']; ?>.jpg" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>" class="avatar-small" style="width:32px;height:32px;">
<?php 
                                    }
                                }
?>
                                <div class="ms-2 w-100" style="min-width:0;">
                                    <div class="d-flex justify-content-between">
                                        <span class="d-inline-block text-truncate w-100"><?php echo $updateText; ?></span>
                                        <?php if ( $updateStatus ) : ?>
                                            <span class="badge rounded-pill <?php echo $class; ?>">
                                                <span class="align-middle"><?php echo $updateStatus; ?></span>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <span class="small text-muted">
                                            <?php echo $notification['project']['title']; ?> Project
                                        </span>
                                        <span class="small text-muted ms-auto"><?php echo time_elapsed_string($notification['createdAt']); ?></span>
                                    </div>
                                </div>
                            </div>
                    <?php if ( $link ) : ?>
                        </a>
                    <?php else : ?>
                        </li>
                    <?php endif; ?>
<?php
                    break;
                case 'thumb' :
                    if ( $user['client'] && !$user['client']['social'] ) {
                        $divider = false;
                        break;
                    }

                    $avatar = true;
                    $link   = true;

                    $updateText = ( $notification['updateType'] == 'insert' )
                        ? "$displayName liked a ".$notification['scrollTo']['text']
                        : "$displayName un-liked a ".$notification['scrollTo']['text']
                    ;

                    if ( in_array($notification['objectId'], $deleted) ) {
                        $link = false;

                        if ( $user['client'] ) {
                            $divider = false;
                            break;
                        }
                    }
?>
                    <?php if ( $link ) : ?>
                        <a href="<?php echo URL_APP ?>/project/?projectId=<?php echo $notification['project']['id']; ?>&view=s&page=<?php echo $notification['page']; ?>#btb-<?php echo $notification['scrollTo']['text']; ?>-<?php echo $notification['scrollTo']['anchor']; ?>" class="dropdown-item">
                    <?php else : ?>
                        <li class="dropdown-item">
                    <?php endif; ?>
                            <!-- <p class="small text-muted ms-auto mb-0">New Post</p> -->
                            <div class="d-flex align-items-center">
<?php 
                                if ( $avatar ) {
                                    if ( !file_exists(PATH_ASSETS.'/images/avatar/'.$notification['user']['name'].'.jpg')) {
                                        $parts    = explode(' ', $notification['user']['name']);
                                        $initials = substr($parts[0], 0, 1) . substr(end($parts), 0, 1);
?>
                                        <div class="initial-avatar-notifications flex-shrink-0" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>"><?php echo $initials; ?></div>
<?php
                                    } else {
?>
                                    <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $notification['user']['name']; ?>.jpg" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>" class="avatar-small" style="width:32px;height:32px;">
<?php 
                                    }
                                }
?>
                                <div class="ms-2 w-100" style="min-width:0;">
                                    <span class="d-inline-block text-truncate w-100"><?php echo $updateText; ?></span>
                                    <div class="d-flex justify-content-between">
                                        <span class="small text-muted lh-1"><?php echo $notification['project']['title']; ?> Project</span>
                                        <span class="small text-muted lh-1 ms-auto"><?php echo time_elapsed_string($notification['createdAt']); ?></span>
                                    </div>
                                </div>
                            </div>
                    <?php if ( $link ) : ?>
                        </a>
                    <?php else : ?>
                        </li>
                    <?php endif; ?>
<?php
                    break;

                case 'visit':
                    $updateText = "$displayName visited the portal for the first time today";
                    if ( $notification['user']['clientId'] ) {
                        $role = 'Client';
                    } else if ( $notification['user']['superAdmin'] ) {
                        $role = 'Super Admin';
                    } else {
                        $role = 'Admin';
                    }
?>
                    <li class="dropdown-item">
                        <div class="d-flex align-items-center">
<?php 
                            if ( !file_exists(PATH_ASSETS.'/images/avatar/'.$notification['user']['name'].'.jpg')) {
                                $parts    = explode(' ', $notification['user']['name']);
                                $initials = substr($parts[0], 0, 1) . substr(end($parts), 0, 1);
?>
                                <div class="initial-avatar-notifications flex-shrink-0" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>"><?php echo $initials; ?></div>
<?php
                            } else {
?>
                                <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $notification['user']['name']; ?>.jpg" alt="<?php echo $notification['user']['name']; ?>" title="<?php echo $notification['user']['name']; ?>" class="avatar-small" style="width:32px;height:32px;">
<?php 
                            }
?>
                            <div class="ms-2 w-100" style="min-width:0;">
                                <span class="d-inline-block text-truncate w-100"><?php echo $updateText; ?></span>
                                <div class="d-flex justify-content-between">
                                    <span class="small text-muted lh-1"><?php echo $role; ?></span>
                                    <span class="small text-muted lh-1 ms-auto"><?php echo time_elapsed_string($notification['createdAt']); ?></span>
                                </div>
                            </div>
                        </div>
                    </li>
<?php
                    break;
            }
?>
            <?php if ( $divider ) : ?><li><hr class="dropdown-divider"></li><?php endif; ?>
<?php 
            $j++;
        endforeach;
?>