<?php
    if ( !$user['superAdmin'] ) {
        exit;
    }

    if ( $clientId = $_POST['id'] ) {
        $client         = $db->row("SELECT * FROM client WHERE id = ?", $clientId);
        $client['user'] = $db->row("SELECT * FROM user WHERE clientId = ?", $clientId);

        $ids     = $db->run("SELECT * FROM client_project WHERE clientId = ?", $client['id']);
        foreach ( $ids as $id ) {
            $client['projects'][] = $db->row("SELECT * FROM project WHERE id = ?", $id['projectId']);
        }

        $projects = $db->run("SELECT * FROM project");
    }

    if ( $client ) :
?>
        <div class="form-floating mb-2">
            <input type="text" name="name" class="form-control" id="name" value="<?php echo $client['user']['name']; ?>" required>
            <label for="name">Name</label>
        </div>
        <div class="form-floating mb-2">
            <input type="email" name="email" class="form-control" id="email" value="<?php echo $client['email']; ?>" required>
            <label for="email">Email</label>
        </div>
        <div class="form-check text-start my-2 mx-1">
            <?php
                $checked = ( $client['social'] )
                    ? 'checked=checked'
                    : ''
                ;
            ?>
            <input class="form-check-input" type="checkbox" id="social" name="social" value="1" <?php echo $checked; ?>>
            <label class="form-check-label" for="social">
                Allow social view (client can comment)
            </label>
        </div>
        <div class="form-check text-start my-2 mx-1">
            <?php
                $checked = ( $client['observer'] )
                    ? 'checked=checked'
                    : ''
                ;
            ?>
            <input class="form-check-input" type="checkbox" id="observer" name="observer" value="1" <?php echo $checked; ?>>
            <label class="form-check-label" for="observer">
                Observer <small>(client can see selected projects but cannot interact)</small>
            </label>
        </div>
        <div class="form-check text-start my-2 mx-1">
            <?php
                $checked = ( $client['user']['active'] )
                    ? 'checked=checked'
                    : ''
                ;
            ?>
            <input class="form-check-input" type="checkbox" id="active" name="active" value="1" <?php echo $checked; ?>>
            <label class="form-check-label" for="active">
                Allow portal login
            </label>
        </div>
        <hr>
        <label for="clientProjects" class="small text-muted ms-2">Projects</label>
        <div class="mx-2">
            <select name="clientProjects[]" class="selectpicker my-1" multiple data-live-search="true" title="Select projects" data-selected-text-format="count > 2" data-width="100%">
                <?php 
                    foreach ( $projects as $project ) : 
                        if ( $client['projects'] && in_array($project['id'], array_column($client['projects'], 'id')) ) {
                            $selected = 'selected';
                        } else {
                            $selected = '';
                        }
                        $title = $project['title'];
                ?>
                    <option value="<?php echo $project['id']; ?>" <?php echo $selected; ?>><?php echo $title; ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <input type="hidden" name="clientId" id="clientId" value="<?php echo $client['id']; ?>">
        <input type="hidden" name="userId" id="userId" value="<?php echo $client['user']['id']; ?>">
<?php
    endif;
?>