<?php
    if ( !$user['superAdmin'] ) {
        exit;
    }

    if ( $projectId = $_POST['id'] ) {
        $project = $db->row("SELECT * FROM project WHERE id = ?", $projectId);
        $ids     = $db->run("SELECT * FROM client_project WHERE projectId = ?", $project['id']);
        foreach ( $ids as $id ) {
            $project['clients'][] = $db->row("SELECT * FROM client WHERE id = ?", $id['clientId']);
        }
        
        $clients = [];
        $clients = $db->run("SELECT * FROM client");

        $adminUsers    = $db->run("SELECT * FROM user WHERE admin = 1 AND superAdmin = 0 AND clientId = 0");
        $notifications = $db->run("SELECT * FROM project_email_notification WHERE projectId = ?", $projectId);

        $sheetId = $project['sheetId'];
    }

    if ( $project ) :
?>
        <div class="form-floating mb-2">
            <input type="text" name="title" class="form-control" id="title" value="<?php echo $project['title']; ?>" required>
            <label for="name">Title</label>
        </div>
        <div class="form-floating mb-2">
            <select id="status" name="status" class="form-select form-control" required>
                <option value="">Select project status</option>
                <option value="Active" <?php if ( $project['status'] === 'Active' ) : ?>selected<?php endif; ?>>Active</option>
                <option value="Completed" <?php if ( $project['status'] === 'Completed' ) : ?>selected<?php endif; ?>>Completed</option>
                <option value="Negotiating" <?php if ( $project['status'] === 'Negotiating' ) : ?>selected<?php endif; ?>>Negotiating</option>
                <option value="Paused" <?php if ( $project['status'] === 'Paused' ) : ?>selected<?php endif; ?>>Paused</option>
            </select>
            <label for="status">Project status</label>
        </div>
        <div class="input-group mb-2">
            <div class="form-floating">
                <!-- <input type="text" name="sheetId" class="form-control" id="sheetId" required> -->
                <select id="editProjectTaskListSelect" name="sheetId" class="form-select form-control" data-id="<?php echo $sheetId; ?>" required>
                    <option value="">Loading sheets...</option>
                </select>
                <label for="sheetId">Sheet ID</label>
            </div>
            <label id="editProjectTaskListLoader" class="input-group-text">
                <div class="d-flex">
                    <div class="spinner-border spinner-border-sm text-danger" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </label>
        </div>
        <div class="form-floating mb-2">
            <input type="text" name="zip" class="form-control" id="zip" value="<?php echo $project['zip']; ?>" required>
            <label for="email">ZIP (used to fetch weather)</label>
        </div>
        <div class="form-floating mb-2">
            <input type="text" name="city" class="form-control" id="city" value="<?php echo $project['city']; ?>" required>
            <label for="email">City (used for display only)</label>
        </div>
        <hr>
        <label for="projectClients" class="small text-muted ms-2">Clients</label>
        <div class="mx-2">
            <select name="projectClients[]" class="selectpicker my-1" multiple data-live-search="true" title="Select clients" data-selected-text-format="count > 2" data-width="100%">
                <?php 
                    foreach ( $clients as $client ) : 
                        if ( $project['clients'] && in_array($client['id'], array_column($project['clients'], 'id')) ) {
                            $selected = 'selected';
                        } else {
                            $selected = '';
                        }
                        $name = $db->cell("SELECT name FROM user WHERE id = ?", $client['userId']);
                ?>
                    <option value="<?php echo $client['id']; ?>" <?php echo $selected; ?>><?php echo $name; ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <hr>
        <label for="projectUserNotifications" class="small text-muted ms-2">Email notifications</label>
        <div class="mx-2">
            <select name="projectUserNotifications[]" class="selectpicker my-1" multiple data-live-search="true" title="Select users" data-selected-text-format="count > 2" data-width="100%">
                <?php 
                    foreach ( $adminUsers as $adminUser ) : 
                        if ( in_array($adminUser['id'], array_column($notifications, 'userId')) && in_array($projectId, array_column($notifications, 'projectId')) ) {
                            $selected = 'selected';
                        } else {
                            $selected = '';
                        }
                        $name = $adminUser['name'];
                ?>
                    <option value="<?php echo $adminUser['id']; ?>" <?php echo $selected; ?>><?php echo $name; ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <input type="hidden" name="projectId" id="projectId" value="<?php echo $project['id']; ?>">
<?php
    endif;
?>