<?php
    if ( !$user['superAdmin'] ) {
        exit;
    }

    if ( $userId = $_POST['id'] ) {
        $userToEdit    = $db->row("SELECT * FROM user WHERE id = ?", $userId);
        $notifications = $db->run("SELECT * FROM project_email_notification WHERE userId = ?", $userToEdit['id']);
        $projects      = $db->run("SELECT * FROM project");
    }

    if ( $userToEdit ) :
?>
        <div class="form-floating mb-2">
            <input type="name" name="name" class="form-control" id="name" value="<?php echo $userToEdit['name']; ?>" required>
            <label for="name">Name</label>
        </div>
        <div class="form-floating mb-2">
            <input type="email" name="email" class="form-control" id="email" value="<?php echo $userToEdit['email']; ?>" required>
            <label for="email">Email</label>
        </div>
        <div class="form-floating mb-2">
            <input type="email" name="ssEmail" class="form-control" id="ssEmail" value="<?php echo $userToEdit['ssEmail']; ?>">
            <label for="ssEmail">Smartsheet Email</label>
        </div>
        <div class="form-check text-start my-2 mx-1">
            <?php
                $checked = ( $userToEdit['admin'] )
                    ? 'checked=checked'
                    : ''
                ;
            ?>
            <input class="form-check-input" type="checkbox" id="admin" name="admin" value="1" <?php echo $checked; ?>>
            <label class="form-check-label" for="admin">
                Admin
            </label>
        </div>
        <div class="form-check text-start my-2 mx-1">
            <?php
                $checked = ( $userToEdit['superAdmin'] )
                    ? 'checked=checked'
                    : ''
                ;
            ?>
            <input class="form-check-input" type="checkbox" id="superAdmin" name="superAdmin" value="1" <?php echo $checked; ?>>
            <label class="form-check-label" for="active">
                Super Admin
            </label>
        </div>
        <div class="form-check text-start my-2 mx-1">
            <?php
                $checked = ( $userToEdit['active'] )
                    ? 'checked=checked'
                    : ''
                ;
            ?>
            <input class="form-check-input" type="checkbox" id="active" name="active" value="1" <?php echo $checked; ?>>
            <label class="form-check-label" for="active">
                Allow portal login
            </label>
        </div>
        <?php if ( !$userToEdit['superAdmin'] ) : ?>
            <hr>
            <label for="userProjectNotifications" class="small text-muted ms-2">Email notifications</label>
            <div class="mx-2">
                <select name="userProjectNotifications[]" class="selectpicker my-1" multiple data-live-search="true" title="Select projects" data-selected-text-format="count > 2" data-width="100%">
                    <?php 
                        foreach ( $projects as $project ) : 
                            if ( in_array($userToEdit['id'], array_column($notifications, 'userId')) && in_array($project['id'], array_column($notifications, 'projectId')) ) {
                                $selected = 'selected';
                            } else {
                                $selected = '';
                            }
                            $title = $project['title'];
                    ?>
                        <option value="<?php echo $project['id']; ?>" <?php echo $selected; ?>><?php echo $title; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        <?php endif; ?>
        <input type="hidden" name="userId" id="userId" value="<?php echo $userToEdit['id']; ?>">
<?php
    endif;
?>