<?php
    if ( !$user['admin'] ) {
        exit;
    }

    if ( $clientId = $_POST['id'] ) {
        $client         = $db->row("SELECT * FROM client WHERE id = ?", $clientId);
        $client['user'] = $db->row("SELECT * FROM user WHERE clientId = ?", $clientId);
        $actions        = $db->run("SELECT * FROM action WHERE userId = ? ORDER BY id DESC LIMIT 0,100", $client['user']['id']);
        $count          = $db->cell("SELECT COUNT(*) AS count FROM action WHERE userId = ?", $client['user']['id']);
    }

    if ( $actions ) :
?>
        <div id="clientLogsTable" class="table-responsive collapse show">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr class="text-center">
                        <th scope="col">#</th>
                        <th scope="col">Token ID</th>
                        <th scope="col">Action</th>
                        <th scope="col">Target</th>
                        <th scope="col">Theme</th>
                        <th scope="col">View</th>
                        <th scope="col">Date/Time</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        $k      = 0;
                        $agents = [];

                        foreach( $actions as $action ) :
                            $date = explode(' ', $action['createdAt'])[0];
                            if ( $date !=  explode(' ', $actions[$k+1]['createdAt'])[0]) {
                                $border = "2px solid red";
                            } else {
                                $border = '';
                            }
                            
                            if ( !in_array($action['tokenId'], array_keys($agents)) ) {
                                $agents[$action['tokenId']] = $db->cell("SELECT ua FROM auth_token WHERE id = ?", $action['tokenId']);
                            }
                    ?>
                        <tr class="text-center" style="border-bottom:<?php echo $border; ?>;">
                            <th scope="row"><?php echo $count; ?></th>
                            <td>
                                <?php echo $action['tokenId']; ?>
                                <br>
                                <?php echo $agents[$action['tokenId']]; ?>
                            </td>
                            <td><?php echo $action['action']; ?></td>
                            <td><?php echo $action['target']; ?></td>
                            <td><?php echo $action['mode'] ?? 'N/A'; ?></td>
                            <td><?php echo $action['view'] ?? 'N/A'; ?></td>
                            <td><?php echo $action['createdAt']; ?></td>
                        </tr>
                    <?php 
                            $count--;
                            $k++;
                        endforeach; 
                    ?>
                </tbody>
            </table>
        </div>
<?php
// var_dump($agents);
    else :
?>
    <p>No logs for this client</p>
<?php
    endif;
?>