<?php 
    if ( !$user['admin'] ) {
        session_start();
        $_SESSION['error'] = "Unauthorized";

        header('Location: '.URL_APP.'/dashboard/');
        exit;
    }

    session_start();
    if ( isset($_SESSION['error']) ) {
        $error = $_SESSION['error'];
        unset($_SESSION['error']);
    } else {
        $error = false;
    }

    $projects = $db->run("SELECT * FROM project ORDER BY id ASC");
    $clients  = $db->run("SELECT * FROM client ORDER BY id ASC");
    if ( $user['superAdmin'] ) {
        $viewOnlyUsers = $db->run("SELECT * FROM user WHERE clientId = 0 ORDER BY id ASC");
        $clientUsers   = $db->run("SELECT * FROM user WHERE clientId > 0 ORDER BY id ASC");
    }

    include 'layout/header.php'; 
?>

<style>
</style>

<?php include 'template/toolbar.php'; ?>

<?php if ( $error ) : ?>
    <div class="container-fluid container-lg">
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <?php echo $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
<?php endif; ?>

<div class="container-fluid px-0 mb-5">
    <div class="border-top border-bottom p-3" style="background-color: var(--bs-tertiary-bg);">
        <div class="d-flex justify-content-between">
            <div class="d-block">
                <h3 class="m-0">Projects (<?php echo count($projects); ?>)</h3>
                <button id="projectsTableToggle" class="btn btn-link p-0 text-danger btbAction" data-action="click" data-target="projects table toggle" data-bs-toggle="collapse" data-bs-target="#projectsTable" onclick="this.textContent = ( this.textContent == 'Collapse' ) ? 'Expand' : 'Collapse';">Collapse</button>
            </div>
            <div class="d-block">
                <?php if ( $user['superAdmin'] ) : ?>
                    <!-- <a type="button" class="btn btn-danger btbAction" data-action="click" data-target="fetch all button" href="<?php echo URL_APP_ADMIN; ?>/src/fetch.php">Fetch All</a> -->
                    <button type="button" class="btn btn-danger btbAction" data-action="click" data-target="new project button" data-bs-toggle="modal" data-bs-target="#newProjectModal">New</button>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php include 'template/projects-table.php'; ?>
</div>

<div class="container-fluid px-0 mb-5">
    <div class="border-top border-bottom p-3" style="background-color: var(--bs-tertiary-bg);">
        <div class="d-flex justify-content-between">
            <div class="d-block">
                <h3 class="m-0">Clients (<?php echo count($clients); ?>)</h3>
                <button id="clientsTableToggle" class="btn btn-link p-0 text-danger btbAction" data-action="click" data-target="clients table toggle" data-bs-toggle="collapse" data-bs-target="#clientsTable" onclick="this.textContent = ( this.textContent == 'Collapse' ) ? 'Expand' : 'Collapse';">Expand</button>
            </div>
            <div class="d-block">
                <?php if ( $user['superAdmin'] ) : ?>
                    <button type="button" class="btn btn-danger btbAction" data-action="click" data-target="new client button"data-bs-toggle="modal" data-bs-target="#newClientModal">New</button>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php include 'template/clients-table.php'; ?>
</div>

<?php if ( $user['superAdmin'] ) : ?>
    <div class="container-fluid px-0 mb-5">
        <div class="border-top border-bottom p-3" style="background-color: var(--bs-tertiary-bg);">
            <div class="d-flex justify-content-between">
                <div class="d-block">
                    <h3 class="m-0">Users (<?php echo count($viewOnlyUsers); ?>)</h3>
                    <button id="usersTableToggle" class="btn btn-link p-0 text-danger btbAction" data-action="click" data-target="users table toggle" data-bs-toggle="collapse" data-bs-target="#usersTable" onclick="this.textContent = ( this.textContent == 'Collapse' ) ? 'Expand' : 'Collapse';">Expand</button>
                </div>
                <div class="d-block">
                    <button type="button" class="btn btn-danger btbAction" data-action="click" data-target="new user button" data-bs-toggle="modal" data-bs-target="#newUserModal">New</button>
                </div>
            </div>
        </div>
        <?php include 'template/users-table.php'; ?>
    </div>

    <div class="container-fluid px-0 mb-5">
        <div class="border-top border-bottom p-3" style="background-color: var(--bs-tertiary-bg);">
            <div class="d-flex justify-content-between">
                <div class="d-block">
                    <div class="d-flex">
                        <h3 class="m-0">Webhooks</h3>
                        <span id="webhooksTableLoader" class="ms-2"></span>
                    </div>
                    <button id="webhooksTableToggle" class="btn btn-link p-0 text-danger btbAction" data-action="click" data-target="webhooks table toggle" data-bs-toggle="collapse" data-bs-target="#webhooksTable" onclick="this.textContent = ( this.textContent == 'Collapse' ) ? 'Expand' : 'Collapse';">Expand</button>
                </div>
                <div class="d-block">
                    <!-- <button type="button" class="btn btn-danger btbAction" data-action="click" data-target="new user button" data-bs-toggle="modal" data-bs-target="#newUserModal">New</button> -->
                </div>
            </div>
        </div>
        <div id="webhooksTableContainer">
            <?php // include 'template/webhooks-table.php'; ?>
        </div>
    </div>
<?php endif; ?>

<?php 
    if ( $user['superAdmin'] ) {
         include 'template/new-project-modal.php'; 
         include 'template/edit-project-modal.php'; 
        
         include 'template/new-user-modal.php'; 
         include 'template/edit-user-modal.php'; 
        
         include 'template/new-client-modal.php'; 
         include 'template/edit-client-modal.php'; 
        
         include 'template/user-logs-modal.php'; 

         include 'template/send-token-modal.php'; 
    }

    include 'template/client-logs-modal.php';

    include 'layout/footer.php';
?>