<div class="AIResponse" id="<?php echo $message['anthropicId']; ?>">
    <div class="d-flex justify-content-between">
        <span class="small text-muted text-truncate bg-body rounded px-1" data-bs-toggle="tooltip" data-bs-title="<?php echo htmlspecialchars($message['prompt']['text'], ENT_QUOTES | ENT_HTML5, 'UTF-8'); ?>"><?php echo htmlspecialchars($message['prompt']['text'], ENT_QUOTES | ENT_HTML5, 'UTF-8'); ?></span>
        <span class="small text-muted text-nowrap ms-2"><?php echo time_elapsed_string($message['prompt']['createdAt']); ?></span>
    </div>
    <p>
        <?php
            $text = nl2br(htmlspecialchars($message['text'], ENT_QUOTES | ENT_HTML5, 'UTF-8'));
            
            if ( strpos($text, '[websearch]') !== false ) {
                $text = str_replace('[websearch]', '<br /><br />', $text);
                $text = str_replace('[/websearch]', '<br />', $text);

                $text = str_replace('[searchquery]', '<strong>', $text);
                $text = str_replace('[/searchquery]', '</strong>', $text);

                $text = substr_replace($text, '/a><br /><br />', strrpos($text, '[/searchresult]'), 15);
                $text = str_replace('[searchresult]', '- <a class="text-danger" target="_blank" href=', $text);
                $text = str_replace('[/searchresult]', '/a><br />', $text);

                $text = str_replace('[resulturl]', '"', $text);
                $text = str_replace('[/resulturl]', '"', $text);

                $text = str_replace('[resulttitle]', '>', $text);
                $text = str_replace('[/resulttitle]', '<', $text);
            }
            echo $text;
        ?>
    </p>
    <div class="d-flex justify-content-between align-items-center">
        <div class="hstack gap-1">
            <?php 
                if ( $message['prompt'] ) :
                    foreach ( $message['prompt']['attachments'] as $attachment ) : 
                        $attachmentId = $attachment['id'];

                        $baseSrc  = URL_AI_ATTACHMENTS;
                        $basePath = PATH_AI_ATTACHMENTS;

                        $attachmentExt = strtolower(pathinfo($baseSrc.'/'.$attachment['filename'], PATHINFO_EXTENSION));

                        $link = $baseSrc.'/'.$attachment['filename'];
                        $dl   = $link;
                        $src  = ( $attachmentExt === 'pdf' )
                            ? URL_ASSETS.'/images/pdf-icon.png'
                            : $link
                        ;

                        if ( file_exists("$basePath/small/$attachment[filename]") ) {
                            $link = "$baseSrc/small/$attachment[filename]";
                            $src  = $link;
                        }
                        if ( file_exists("$basePath/thumbs/$attachment[filename]") ) {
                            $src = "$baseSrc/thumbs/$attachment[filename]";
                        }
            ?>
                        <div style="height:50px;width:50px;">
                            <div class="position-relative overflow-hidden" style="padding-bottom:100%;">
                                <a href="<?php echo $link; ?>" class="lightboxLink" rel="btb-lb-<?php echo $message['id']; ?>" data-fancybox="btb-post-<?php echo $message['id']; ?>" data-download-src="<?php echo $dl; ?>" <?php if ( $attachmentExt === 'pdf' ) : ?> data-type="pdf"<?php endif; ?>>
                                    <img 
                                        data-src="<?php echo $src; ?>" 
                                        alt="<?php echo $attachment['filename'] ?>" 
                                        class="lazy img-thumbnail position-absolute object-fit-cover w-100 h-100"
                                    >
                                </a>
                            </div>
                        </div>
            <?php 
                    endforeach;
                endif;
            ?>
        </div>
        <button class="aiCopyResponse btn btn-sm bg-body border" title="Copy" data-clipboard-text="<?php echo htmlspecialchars($message['text'], ENT_QUOTES | ENT_HTML5, 'UTF-8'); ?>">
            <i class="bi bi-copy"></i>
        </button>
    </div>
</div>

<hr class="endAIResponse">