<div id="clientsTable" class="table-responsive px-3 collapse">
    <table id="clientsDT" class="table table-striped table-bordered table-hover table-sm border-top border-bottom w-100">
        <thead>
            <tr class="text-center">
                <th scope="col">#</th>
                <th scope="col">ID</th>
                <th scope="col">Name</th>
                <th scope="col">Email</th>
                <th scope="col">Social</th>
                <th scope="col">Is Active</th>
                <th scope="col">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $i = 1;
                foreach( $clients as $client ) : 
                    $client['user'] = $db->row("SELECT * FROM user WHERE id = ?", $client['userId']);
            ?>
                <tr class="text-center">
                    <td><?php echo $i; ?></td>
                    <td><?php echo $client['id']; ?></td>
                    <td class="fw-bold">
                        <?php if ( $user['superAdmin'] ) : ?>
                            <a class="editClientButton btbAction text-danger" data-action="click" data-target="edit client <?php echo $client['userId']; ?> button" href="" data-id="<?php echo $client['id']; ?>" data-bs-toggle="modal" data-bs-target="#editClientModal"><?php echo $client['user']['name']; ?></a>
                        <?php else : ?>
                            <?php echo $client['user']['name']; ?>
                        <?php endif; ?>
                    </td>
                    <td><?php echo $client['email']; ?></td>
                    <td>
                        <?php 
                            $social = ( $client['social'] )
                                ? 'Yes'
                                : 'No'
                            ;
                            echo $social;
                        ?>
                    </td>
                    <td>
                        <?php 
                            $active = ( $client['user']['active'] )
                                ? 'Yes'
                                : 'No'
                            ;
                            echo $active;
                        ?>
                    </td>
                    <td class="text-center">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" style="--bs-btn-padding-y: .25rem; --bs-btn-padding-x: .5rem; --bs-btn-font-size: .75rem;">
                                Actions
                            </button>
                            <ul class="dropdown-menu">
                                <?php if ( $user['superAdmin'] ) : ?>
                                    <li><h6 class="dropdown-header">Super Admin</h6></li>
                                    <li><a class="dropdown-item editClientButton btbAction" data-action="click" data-target="edit client <?php echo $client['userId']; ?> button" href="" data-id="<?php echo $client['id']; ?>" data-bs-toggle="modal" data-bs-target="#editClientModal">Edit</a></li>
                                    <li><a class="dropdown-item btbAction" data-action="click" data-target="impersonate client <?php echo $client['userId']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/impersonate.php?id=<?php echo $client['userId']; ?>">Impersonate</a></li>
                                    <li><a class="dropdown-item btbAction" data-action="click" data-target="logout all devices client <?php echo $client['userId']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/logout-all-devices.php?id=<?php echo $client['userId']; ?>">Log out all devices</a></li>
                                    <li><a class="dropdown-item sendTokenButton btbAction" data-action="click" data-target="send login token client <?php echo $client['userId']; ?> button" href="" data-id="<?php echo $client['id']; ?>" data-bs-toggle="modal" data-bs-target="#sendTokenModal">Send login token</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                <?php endif; ?>
                                <li><h6 class="dropdown-header">Admin</h6></li>
                                <li><a class="dropdown-item viewClientLogsButton btbAction" data-action="click" data-target="view client <?php echo $client['userId']; ?> logs button" href="" data-id="<?php echo $client['id']; ?>" data-bs-toggle="modal" data-bs-target="#clientLogsModal">View logs</a></li>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php 
                    $i++;
                endforeach; 
            ?>
        </tbody>
    </table>
</div>