<div id="newClientModal" class="modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">New Client</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo URL_APP_ADMIN; ?>/src/new-client.php" method="POST" id="newClientForm">
                <div id="newClientModalBody" class="modal-body">
                    <div class="form-floating mb-2">
                        <input type="text" name="name" class="form-control" id="name" required>
                        <label for="name">Name</label>
                    </div>
                    <div class="form-floating mb-2">
                        <input type="email" name="email" class="form-control" id="email" required>
                        <label for="email">Email</label>
                    </div>
                    <div class="form-check text-start my-2 mx-1">
                        <input class="form-check-input" type="checkbox" id="social" name="social" value="1">
                        <label class="form-check-label" for="social">
                            Allow social view (client can comment)
                        </label>
                    </div>
                    <div class="form-check text-start my-2 mx-1">
                        <input class="form-check-input" type="checkbox" id="observer" name="observer" value="1">
                        <label class="form-check-label" for="observer">
                            Observer <small>(client can see selected projects but cannot interact)</small>
                        </label>
                    </div>
                    <div class="form-check text-start my-2 mx-1">
                        <input class="form-check-input" type="checkbox" id="active" name="active" value="1">
                        <label class="form-check-label" for="active">
                            Allow portal login
                        </label>
                    </div>
                    <div class="form-check text-start mx-1">
                        <input class="form-check-input" type="checkbox" id="addProjectClient" name="addProjectClient" value="1">
                        <label class="form-check-label" for="addProjectClient">
                            Add client to project(s)
                        </label>
                    </div>
                    <div class="d-none mx-1" id="projectClient">
                        <select name="projects[]" class="selectpicker my-1" multiple data-live-search="true" title="Select projects" data-selected-text-format="count > 2" data-width="100%">
                            <?php foreach ( $projects as $project ) : ?>
                                <option value="<?php echo $project['id']; ?>"><?php echo $project['title']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger btbAction" data-action="click" data-target="save new client">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>