<div id="newPublicProjectModal" class="modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">New Public Project</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo URL_APP_ADMIN; ?>/src/new-public-project.php" method="POST" name="newPublicProjectForm" id="newPublicProjectForm">
                <div id="newPublicProjectModalBody" class="modal-body">
                    <div class="form-floating mb-2">
                        <input type="text" name="title" class="form-control" id="publicProjectTitle" required>
                        <label for="title">Title</label>
                    </div>
                    <!-- <div class="form-floating mb-2"> -->
                    <div class="mb-2">
                        <textarea name="description" id="publicProjectDescription" class="form-control p-2" placeholder="Public project description" rows="4" style="resize:none;"></textarea>
                        <!-- <label for="description">Description</label> -->
                    </div>
                    <div class="form-floating mb-2">
                        <select name="projectId" class="form-select form-control" id="publicProjectProjectId">
                            <option value="">Select Portal Project</option>
                            <?php foreach ( $projects as $project ) : ?>
                                <option value="<?php echo $project['id']; ?>"><?php echo $project['title']; ?></option>
                            <?php endforeach; ?>
                        </select>
                        <label for="projectId">Project ID (if any)</label>
                    </div>
                    <div class="form-floating mb-2">
                        <select name="status" class="form-select form-control" id="publicProjectStatus" required>
                            <option value="">Select Status</option>
                            <option value="Completed">Completed</option>
                            <option value="Contracted">Contracted</option>
                            <option value="In Design">In Design</option>
                            <option value="In Progress">In Progress</option>
                            <option value="Pending">Pending</option>
                        </select>
                        <label for="status">Status</label>
                    </div>
                    <div class="form-floating mb-2">
                        <input type="text" name="city" class="form-control" id="publicProjectCity" required>
                        <label for="city">City</label>
                    </div>
                    <div class="input-group mb-2">
                        <span class="input-group-text">$</span>
                        <div class="form-floating form-floating-group flex-grow-1">
                            <input type="number" name="value" id="publicProjectValue" class="form-control">
                            <label for="value">Dollar Value (numbers only)</label>
                        </div>
                    </div>
                    <div class="form-floating mb-2">
                        <select name="type" class="form-select form-control" id="publicProjectType" required>
                            <option value="">Select Type</option>
                            <option value="Design & Timber MFG + Install">Design & Timber MFG + Install</option>
                            <option value="Design-Build-Dry-in">Design-Build-Dry-in</option>
                            <option value="Design-Build-Turnkey">Design-Build-Turnkey</option>
                            <option value="Land-Develop-Subdivide">Land-Develop-Subdivide</option>
                            <option value="Neighborhood Infrastructure">Neighborhood Infrastructure</option>
                            <option value="Out of State">Out of State</option>
                        </select>
                        <label for="type">Type</label>
                    </div>
                    <div id="publicProjectDropzone" class="d-flex justify-content-center align-items-center rounded overflow-x-scroll" style="border:1px grey dashed;min-height:200px;cursor:pointer;">
                        <div id="addImages" class="text-center">
                            <div class="fw-bold">Add Image(s)</div>
                        </div>
                    </div>
                    <div class="small mt-1 ms-1">
                        <span class="text-muted">Drag and drop or click inside the box to upload files</span>
                        <br> 
                        <span class="text-muted">Max number of files:</span> 100
                        <br>
                        <span class="text-muted">Max size per file:</span> 30MB
                        <br>
                        <span class="text-muted">Max total upload size:</span> 256MB
                        <br>
                        <span class="text-muted">Accepted file types:</span> JPG/JPEG, PNG
                    </div>
                </div>
                <div id="newPublicProjectModalFooter" class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger" data-action="click" data-target="save new public project" id="newPublicProjectSubmit">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>