
<div class="d-flex align-items-center justify-content-between">
    <div class="d-block">
        <span class="fw-bold">Projects (<?php echo count($projects); ?>)</span>
    </div>
    <div class="d-block">
        <?php if ( $user['superAdmin'] ) : ?>
            <!-- <a type="button" class="btn btn-danger btbAction" data-action="click" data-target="fetch all button" href="<?php echo URL_APP_ADMIN; ?>/src/fetch.php">Fetch All</a> -->
            <button type="button" class="btn btn-sm btn-danger" title="New project" data-bs-toggle="modal" data-bs-target="#newProjectModal">
                <i class="bi bi-plus"></i>
            </button>
        <?php endif; ?>
    </div>
</div>

<div id="projectsTable" class="table-responsive">
    <table id="projectsDT" class="table table-striped table-bordered table-hover table-sm border-top border-bottom">
        <thead class="">
            <tr class="text-center">
                <th scope="col">#</th>
                <th scope="col">ID</th>
                <th scope="col">Title</th>
                <th scope="col">Status</th>
                <th scope="col">Location</th>
                <th scope="col">Sheet ID</th>
                <th scope="col">Clients</th>
                <th scope="col">Notifications</th>
                <th scope="col">Started</th>
                <th scope="col">Updated</th>
                <th scope="col">Actions</th>
            </tr>
        </thead>
        <tbody class="">
<?php
                $i = 1;
                foreach ( $projects as $project ) : 
?>
                <tr class="text-center">
                    <td><?php echo $i; ?></td>
                    <td><?php echo $project['id']; ?></td>
                    <td class="fw-bold">
                        <a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>" class="text-danger">
                            <?php echo $project['title']; ?>
                        </a>
                    </td>
                    <?php
                        switch ( $project['status'] ) {
                            case 'Active' :
                                $badge = 'text-bg-success';
                                break;
                            case 'Completed' :
                                $badge = 'text-bg-danger';
                                break;
                            case 'Negotiating' :
                                $badge = 'text-bg-primary';
                                break;
                            case 'Paused' :
                                $badge = 'text-bg-warning';
                                break;
                        }
                    ?>
                    <td>
                        <span class="badge rounded-pill <?php echo $badge; ?>"><?php echo $project['status']; ?></span>
                    </td>
                    <td><?php echo $project['city'].' '.$project['zip']; ?></td>
                    <td>
                        <?php echo $project['sheetId']; ?>
                    </td>
                    <td>
<?php
                            $clientNames = implode(', ', array_column($project['clients'], 'name'));
                            if ( $user['superAdmin'] ) :
                                $k = 0;
                                foreach ( $project['clients'] as $projectClient ) :
?>
                                    <a class="editClientButton btbAction text-danger" data-action="click" data-target="edit client <?php echo $projectClient['id']; ?> button" href="" data-id="<?php echo $projectClient['id']; ?>" data-bs-toggle="modal" data-bs-target="#editClientModal"><?php echo $projectClient['name']; ?></a>
<?php
                                    if ( ($k + 1) != count($project['clients']) ) :
?>
                                        <br>
<?php
                                    endif;
                                    $k++;
                                endforeach;
                            else :
                                echo $clientNames;
                            endif;
?>
                    </td>
                    <td>
<?php
                            $userNames = implode(', ', array_column($project['notifications'], 'name'));
                            if ( $user['superAdmin'] ) :
                                $k = 0;
                                foreach ( $project['notifications'] as $notification ) :
?>
                                    <a class="editUserButton btbAction text-danger" data-action="click" data-target="edit user <?php echo $notification['id']; ?> button" href="" data-id="<?php echo $notification['id']; ?>" data-bs-toggle="modal" data-bs-target="#editUserModal"><?php echo $notification['name']; ?></a>
<?php
                                    if ( ($k + 1) != count($project['notifications']) ) :
?>
                                        <br>
<?php
                                    endif;
                                    $k++;
                                endforeach;
                            else :
                                echo $userNames;
                            endif;
?>
                    </td>
                    <td>
                        <?php if ( $project['createdAt'] ) : ?>
                            <span class="d-none"><?php echo $project['createdAt']; ?></span>
                            <a role="button" data-bs-toggle="tooltip" data-bs-title="<?php echo $project['createdAt']; ?>" class="text-danger p-0">
                                <?php echo time_elapsed_string($project['createdAt']); ?>
                            </a>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ( $project['updatedAt'] ) : ?>
                            <span class="d-none"><?php echo $project['updatedAt']; ?></span>
                            <a role="button" data-bs-toggle="tooltip" data-bs-title="<?php echo $project['updatedAt']; ?>" class="text-danger p-0">
                                <?php echo time_elapsed_string($project['updatedAt']); ?>
                            </a>
                        <?php endif; ?>
                    </td>
                    <td class="text-center">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" style="--bs-btn-padding-y: .25rem; --bs-btn-padding-x: .5rem; --bs-btn-font-size: .75rem;">
                                Actions
                            </button>
                            <ul class="dropdown-menu">
                                <?php if ( $user['superAdmin'] ) : ?>
                                    <li><h6 class="dropdown-header">Super Admin</h6></li>
                                    <?php if ( !$project['webhook'] ) : ?>
                                        <li><a class="dropdown-item btbAction" data-action="click" data-target="create webhook for project <?php echo $project['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/webhook/create.php/?projectId=<?php echo $project['id']; ?>">Create Webhook</a></li>
                                    <?php endif; ?>
                                    <li><a class="dropdown-item editProjectButton btbAction" data-action="click" data-target="edit project <?php echo $project['id']; ?> button" href="" data-id="<?php echo $project['id']; ?>" data-bs-toggle="modal" data-bs-target="#editProjectModal">Edit</a></li>
                                    <li><a class="dropdown-item btbAction" data-action="click" data-target="fetch project <?php echo $project['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/fetch.php/?projectId=<?php echo $project['id']; ?>">Fetch</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                <?php endif; ?>
                                <li><h6 class="dropdown-header">Admin</h6></li>
                                <li><a class="dropdown-item btbAction" data-action="click" data-target="view project <?php echo $project['id']; ?> button" href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>">View</a></li>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php 
                    $i++;
                endforeach;
            ?>
        </tbody>
    </table>
</div>