
<div class="d-flex align-items-center justify-content-between">
    <div class="d-block">
        <span class="fw-bold">Showcase Tokens (<?php echo count($showcaseTokens); ?>)</span>
    </div>
    <div class="d-block">
        <?php if ( $user['superAdmin'] ) : ?>
            <!-- <a type="button" class="btn btn-danger btbAction" data-action="click" data-target="fetch all button" href="<?php echo URL_APP_ADMIN; ?>/src/fetch.php">Fetch All</a> -->
            <button type="button" class="btn btn-sm btn-danger" title="New showcase project token" data-bs-toggle="modal" data-bs-target="#newShowcaseTokenModal">
                <i class="bi bi-plus"></i>
            </button>
        <?php endif; ?>
    </div>
</div>

<div id="showcaseTokensTable" class="table-responsive">
    <table id="showcaseTokensDT" class="table table-striped table-bordered table-hover table-sm border-top border-bottom">
        <thead class="">
            <tr class="text-center">
                <th scope="col">#</th>
                <th scope="col">ID</th>
                <th scope="col">Showcase ID</th>
                <th scope="col">Value</th>
                <th scope="col">Note</th>
                <th scope="col">Created By</th>
                <th scope="col">Created At</th>
                <th scope="col">Expires At</th>
            </tr>
        </thead>
        <tbody class="">
<?php
                $i = 1;
                foreach ( $showcaseTokens as $showcaseToken ) : 
?>
                <tr class="text-center">
                    <td><?php echo $i; ?></td>
                    <td><?php echo $showcaseToken['id']; ?></td>
                    <td>
                        <a href="#" class="text-danger">
                            <?php echo $showcaseToken['showcaseId']; ?>
                        </a>
                    </td>
                    <td class="fw-bold">
                        <?php echo $showcaseToken['value']; ?>
                    </td>
                    <td><?php echo $showcaseToken['note']; ?></td>
                    <td><?php echo $showcaseToken['createdBy']; ?></td>
                    <td>
                        <a role="button" data-bs-toggle="tooltip" data-bs-title="<?php echo $showcaseToken['createdAt']; ?>" class="text-danger p-0">
                            <?php echo time_elapsed_string($showcaseToken['createdAt']); ?>
                        </a>
                    </td>
                    <td><?php echo $showcaseToken['expiresAt']; ?></td>
                </tr>
            <?php 
                    $i++;
                endforeach;
            ?>
        </tbody>
    </table>
</div>