<div id="webhooksTable" class="table-responsive px-3 collapse">
    <table id="webhooksDT" class="table table-striped table-bordered table-hover table-sm border-top border-bottom w-100">
        <!-- <caption class="caption-top">List of projects</caption> -->
        <thead class="">
            <tr class="text-center">
                <th scope="col">#</th>
                <th scope="col">ID</th>
                <th scope="col">Name</th>
                <th scope="col">Webhook ID</th>
                <th scope="col">Sheet ID</th>
                <th scope="col">Status</th>
                <th scope="col">Created</th>
                <th scope="col">Modified</th>
                <th scope="col">Actions</th>
            </tr>
        </thead>
        <tbody class="">
            <?php
                $i = 1;
                foreach ( $webhooks as $webhook ) : 
            ?>
                <tr class="text-center">
                    <td><?php echo $i; ?></td>
                    <td><?php echo $webhook['id']; ?></td>
                    <td class="fw-bold"><?php echo $webhook['name']; ?></td>
                    <td><?php echo $webhook['ssWebhookId']; ?></td>
                    <td><?php echo $webhook['sheetId']; ?></td>
                    <td><?php echo $webhook['status']; ?></td>
                    <td>
                        <?php 
                            echo $webhook['createdAt'];
                            echo ' ('.time_elapsed_string($webhook['createdAt']).')';
                        ?>
                    </td>
                    <td>
                        <?php 
                            echo $webhook['updatedAt'];
                            echo ' ('.time_elapsed_string($webhook['updatedAt']).')';
                        ?>
                    </td>
                    <td class="text-center overflow-visible">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" style="--bs-btn-padding-y: .25rem; --bs-btn-padding-x: .5rem; --bs-btn-font-size: .75rem;">
                                Actions
                            </button>
                            <ul class="dropdown-menu">
                                <?php if ( $user['superAdmin'] ) : ?>
                                    <li><h6 class="dropdown-header">Super Admin</h6></li>
                                    <li><a class="dropdown-item btbAction" data-action="click" data-target="delete webhook <?php echo $webhook['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/webhook/delete.php/?webhookId=<?php echo $webhook['id']; ?>">Delete</a></li>
                                    <?php if ( $webhook['status'] == 'ENABLED' ) : ?>
                                        <li><a class="dropdown-item btbAction" data-action="click" data-target="disable webhook <?php echo $webhook['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/webhook/disable.php/?webhookId=<?php echo $webhook['id']; ?>">Disable</a></li>
                                    <?php endif; ?>
                                    <?php if ( str_contains($webhook['status'], 'DISABLED') ) : ?>
                                        <li><a class="dropdown-item btbAction" data-action="click" data-target="enable webhook <?php echo $webhook['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/webhook/verify.php/?webhookId=<?php echo $webhook['id']; ?>">Enable</a></li>
                                    <?php endif; ?>
                                    <?php if ( $webhook['status'] == 'NEW_NOT_VERIFIED' ) : ?>
                                        <li><a class="dropdown-item btbAction" data-action="click" data-target="verify webhook <?php echo $webhook['id']; ?> button" href="<?php echo URL_APP_ADMIN; ?>/src/webhook/verify.php/?webhookId=<?php echo $webhook['id']; ?>">Verify</a></li>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php 
                    $i++;
                endforeach;
            ?>
        </tbody>
    </table>
</div>