<?php
    $data = $db->run("SELECT title, vendor, description, link, image, cost, unit, quantity FROM selection_item WHERE projectId = 9 ORDER BY sort ASC");
    // array_unshift($data, ['Title', 'Vendor', 'Description', 'Link', 'Image', 'Cost', 'Unit', 'Quantity']);
?>

<!doctype html>
<html lang="en" data-bs-theme="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Bootstrap demo</title>

    <link href="<?php echo URL_ASSETS; ?>/css/bootstrap.min.css" rel="stylesheet">

    <link rel="stylesheet" href="<?php echo URL_ASSETS ?>/css/handsontable.min.css" />
    <link rel="stylesheet" href="<?php echo URL_ASSETS ?>/css/ht-theme-main.min.css" />

</head>
<body>
    <h3>Table</h3>
    <!-- <div id="tableParent" class="overflow-hidden" style="height:600px;"> -->
    <div id="table" class="ht-theme-main-dark-auto h-100 w-100">

    </div>
    <!-- </div> -->

    <script src="<?php echo URL_ASSETS; ?>/js/jquery.js"></script>
    <script type="text/javascript" src="<?php echo URL_ASSETS ?>/js/handsontable.full.min.js"></script>

    <script>
        const table = document.querySelector('#table');
        const data = <?php echo json_encode($data); ?>;
        // const header = {'Title', 'Vendor', 'Description', 'Link', 'Image', 'Cost', 'Unit', 'Quantity'};
        // data.unshift(header);
        const hot = new Handsontable(table, {
            data,
            startRows: 5,
            startCols: 5,
            height: 'auto',
            width: '100%', 
            colWidths: [100,100,100,100,100,100,100,100],
            rowHeights: 40,
            stretchH: 'all',
            // manualColumnResize: ['100px'],
            // manualRowResize: [40],
            colHeaders: ['Title', 'Vendor', 'Description', 'Link', 'Image', 'Cost', 'Unit', 'Quantity'],
            rowHeaders: true,
            minSpareRows: 1,
            autoWrapRow: true,
            autoWrapCol: true,
            licenseKey: 'non-commercial-and-evaluation',
            bindRowsWithHeaders: true,
            afterChange(change, source) {
                console.log(change);
                console.log(source);
            }
        });

        // console.log(hot.data());
    </script>

    <script src="<?php echo URL_ASSETS; ?>/js/bootstrap.bundle.min.js"></script>
</body>
</html>