<?php 
    if ( !$user['admin'] ) {
        session_start();
        $_SESSION['error'] = "Unauthorized";

        header("Location: https://bigtimberbuilders.com/clients/dashboard");
        exit;
    }

    $clients  = $db->run("SELECT * FROM client");
    $projects = $db->run("SELECT * FROM project");

    session_start();
    if ( isset($_SESSION['error']) ) {
        $error = $_SESSION['error'];
        unset($_SESSION['error']);
    } else {
        $error = false;
    }

    include 'layout/header.php'; 
?>

<div class="container-fluid py-5">
    <h1>Client Portal Admin</h1>
    <div class="d-flex align-items-center justify-content-between mb-5" style="min-height:60px;">
        <div class="d-block">
            <?php if ( $error ) : ?>
                <div class="alert alert-warning alert-dismissible fade show mb-0 mx-1 w-100" role="alert">
                    <?php echo $error; ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
        </div>
        <div class="d-block">
            <a type="button" class="btn btn-danger mx-1" href="/clients/cron/fetch.php">Fetch All</a>
            <button type="button" class="btn btn-danger mx-1" data-bs-toggle="modal" data-bs-target="#addClientModal">Add Client</button>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-striped table-bordered">
            <thead>
                <tr class="text-center">
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Email</th>
                    <th scope="col">Project Name</th>
                    <!-- <th scope="col">Folder Name (ID)</th> -->
                    <th scope="col">Sheet ID</th>
                    <th scope="col">Active</th>
                    <th scope="col">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                    foreach( $clients as $client ) : 
                        $client['user'] = $db->row("SELECT * FROM user WHERE email = ?", $client['email']);
                        // echo "<pre>";
                        // var_dump($client['user']);
                        // echo "</pre>";
                ?>
                    <tr class="text-center">
                        <th scope="row"><?php echo $client['id']; ?></th>
                        <td><?php echo $client['name']; ?></td>
                        <td><?php echo $client['email']; ?></td>
                        <td><?php echo $client['projectName']; ?></td>
                        <!-- <td>
                            <?php //echo $client['folderName']; ?> (<?php //echo $client['folderId']; ?>)
                        </td> -->
                        <td><?php echo $client['sheetId']; ?></td>
                        <td>
                            <?php 
                                $active = ( $client['user']['active'] == "1" )
                                    ? 'Yes'
                                    : 'No'
                                ;
                                echo $active;
                            ?>
                        </td>
                        <td class="text-center">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false" style="--bs-btn-padding-y: .25rem; --bs-btn-padding-x: .5rem; --bs-btn-font-size: .75rem;">
                                    Actions
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="https://bigtimberbuilders.com/clients/cron/fetch.php?id=<?php echo $client['id']; ?>"">Fetch</a></li>
                                    <li><a class="dropdown-item editClientButton" href="" data-id="<?php echo $client['id']; ?>" data-bs-toggle="modal" data-bs-target="#editClientModal">Edit</a></li>
                                    <li><a class="dropdown-item" href="/clients/?clientId=<?php echo $client['id']; ?>">View</a></li>
                                    <!-- <li><a class="dropdown-item" href="https://bigtimberbuilders.com/clients/admin/src/impersonate.php?id=<?php // echo $client['user']['id']; ?>">Impersonate</a></li> -->
                                    <li><a class="dropdown-item" href="https://bigtimberbuilders.com/clients/admin/src/logout-all-devices.php?id=<?php echo $client['user']['id']; ?>">Log out all devices</a></li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<div id="editClientModal" class="modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Client</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="/clients/admin/src/edit-client.php" method="POST" id="editClientForm">
                <div id="editClientModalBody" class="modal-body">
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div id="addClientModal" class="modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Client</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="/clients/admin/src/add-client.php" method="POST" id="addClientForm">
                <div id="addClientModalBody" class="modal-body">
                    <div class="form-floating mb-2">
                        <input type="text" name="name" class="form-control" id="name">
                        <label for="name">Client name</label>
                    </div>
                    <div class="form-floating mb-2">
                        <input type="email" name="email" class="form-control" id="email">
                        <label for="email">Email address</label>
                    </div>
                    <div class="form-floating mb-2">
                        <input type="text" name="projectName" class="form-control" id="projectName">
                        <label for="projectName">Project name</label>
                    </div>
                    <!-- <div class="form-floating mb-2">
                        <input type="text" name="folderName" class="form-control" id="folderName">
                        <label for="folderName">Folder name</label>
                    </div> -->
                    <!-- <div class="form-floating mb-2">
                        <input type="text" name="folderId" class="form-control" id="folderId">
                        <label for="folderId">Folder ID</label>
                    </div> -->
                    <div class="form-floating mb-2">
                        <input type="text" name="sheetId" class="form-control" id="sheetId">
                        <label for="sheetId">Sheet ID</label>
                    </div>
                    <div class="form-floating mb-2">
                        <input type="text" name="zip" class="form-control" id="zip">
                        <label for="zip">Jobsite ZIP code</label>
                    </div>
                    <div class="form-check text-start my-2 mx-1">
                        <input class="form-check-input" type="checkbox" id="active" name="active" value="1">
                        <label class="form-check-label" for="active">
                            Allow portal login
                        </label>
                    </div>
                    <div class="form-check text-start my-2 mx-1">
                        <input class="form-check-input" type="checkbox" id="createSheet" name="createSheet" value="1" disabled>
                        <label class="form-check-label" for="active">
                            Create task list sheet
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger">Add client</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'layout/footer.php'; ?>
    