<!doctype html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="user-scalable=no, width=device-width, initial-scale=1">

    <meta name="format-detection" content="telephone=no">

    <title><?php echo COMPANY_NAME; ?> Client Portal</title>

    <link href="<?php echo URL_ASSETS; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo URL_ASSETS; ?>/icons/bootstrap-icons.css" rel="stylesheet">

    <!-- <link href="<?php echo URL_ASSETS; ?>/css/simple-lightbox.min.css" rel="stylesheet"> -->

    <link href="<?php echo URL_ASSETS; ?>/css/clients.css?t=<?php echo time(); ?>" rel="stylesheet">
    <!-- <link href="<?php echo URL_ASSETS; ?>/css/project.css?t=<?php echo time(); ?>" rel="stylesheet"> -->

    <script src="<?php echo URL_ASSETS; ?>/js/theme.js?t=<?php echo time(); ?>"></script>

    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo URL_BASE; ?>/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo URL_BASE; ?>/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo URL_BASE; ?>/favicon-16x16.png">
    <link rel="manifest" href="<?php echo URL_BASE; ?>/site.webmanifest">

    <style>
        /* .card-img-top {
            width: 100%;
            height: 15vw;
            object-fit: cover;
        } */
    </style>
    
</head>

<body>
    <?php include 'menu.php'; ?>
    <?php // include 'sidebar.php'; ?>

    <div class="container-fluid container-lg">

        <div style="height:480px;"></div>

        <div class="sticky-top d-none d-md-block mb-5">
            <ul class="nav nav-underline bg-body border-bottom justify-content-start" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home-tab-pane" type="button" role="tab" aria-controls="home-tab-pane" aria-selected="true">
                        <span class="small">Social</span>
                    </button>
                </li>

                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile-tab-pane" type="button" role="tab" aria-controls="profile-tab-pane" aria-selected="false">
                        <span class="small">Calendar</span>
                    </button>
                </li>

                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact-tab-pane" type="button" role="tab" aria-controls="contact-tab-pane" aria-selected="false">
                        <span class="small">Tasks</span>
                    </button>
                </li>

                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="disabled-tab" data-bs-toggle="tab" data-bs-target="#disabled-tab-pane" type="button" role="tab" aria-controls="disabled-tab-pane" aria-selected="false">
                        <span class="small">Files</span>
                    </button>
                </li>
            </ul> 
        </div>

        








        <div class="tab-content" id="myTabContent">
            <div class="tab-pane  show active" id="home-tab-pane" role="tabpanel" aria-labelledby="home-tab" tabindex="0">



                <?php $projects = $db->run("SELECT * FROM project"); ?>
                <!-- <div class="row"> -->
                <div class="hstack gap-2 overflow-x-scroll" style="scroll-snap-type: x mandatory;-webkit-scroll-snap-type:x mandatory;">
                    <?php 
                        foreach ( $projects as $project ) : 
                            $pdo                = $db->getPdo();
                            // $stmt               = $pdo->prepare("SELECT client.id, client.userId, client.email, client.name, client.createdBy, client.createdAt FROM client, client_project WHERE client_project.projectId = ? AND client_project.clientId = client.id;");
                            $stmt               = $pdo->prepare("SELECT client.id, client.userId, client.email, client.createdBy, client.createdAt, user.name FROM client, client_project, user WHERE client_project.projectId = ? AND client_project.clientId = client.id AND client.userId = user.id;");
                            $exec               = $stmt->execute([$project['id']]);
                            $project['clients'] = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                            $names = implode(', ', array_column($project['clients'], 'name'));
                            // var_dump($project['clients']);

                            $attachment = $db->row("SELECT * FROM attachment WHERE projectId = ? AND (mimeType = 'image/jpeg' OR mimeType = 'image/png') ORDER BY createdAt DESC LIMIT 0,1", $project['id']);

                            $src = URL_ATTACHMENTS."/$attachment[pathname]";
                            if ( file_exists(PATH_ATTACHMENTS."/small/$attachment[pathname]") ) {
                                $src = URL_ATTACHMENTS."/small/$attachment[pathname]";
                            }
                            if ( file_exists(PATH_ATTACHMENTS."/thumbs/$attachment[pathname]") ) {
                                $src = URL_ATTACHMENTS."/thumbs/$attachment[pathname]";
                            }

                            // $project['city'] = $db->cell("SELECT city FROM weather WHERE projectId = ? ORDER BY date DESC LIMIT 0,1", $project['id']);
                    ?>
                            <div class="card flex-shrink-0" style="scroll-snap-align: start;-webkit-scroll-snap-align: start;max-width:75%;">
                                <?php if ( $attachment ) : ?>
                                    <a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>"><img src="<?php echo $src; ?>" class="card-img-top" alt="Latest Project Image"></a>
                                <?php endif; ?>
                                <div class="card-body d-flex flex-column">
                                    <div class="d-flex justify-content-between">
                                        <div class="d-block text-start">
                                            <h5 class="card-title mb-0">
                                                <a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>" class="text-danger"><?php echo $project['title']; ?> Project</a>
                                            </h5>
                                            <small class="text-muted">Started <?php echo time_elapsed_string($project['createdAt']); ?></small>
                                        </div>
                                        <div class="d-block text-end">
                                            <?php if ( $project['city'] ) : ?><small class="text-muted"><?php echo $project['city']; ?>, <?php echo COMPANY_STATE_ABBR; ?></small><?php endif; ?>
                                            <br>
                                            <?php // if ( $weather['lat'] && $weather['lon'] ) : ?><!--<small class="text-muted">(<?php // echo $weather['lat']; ?>, <?php // echo $weather['lon']; ?>)</small> --><?php // endif; ?>
                                        </div>
                                    </div>
                                    <hr class="my-2">
                                    <ol>
                                        <?php 
                                            foreach ( $project['clients'] as $client ) :
                                        ?>
                                            <li><?php echo $client['name']; ?><br><small class="text-muted"><?php echo $client['email']; ?></small></li>
                                        <?php endforeach; ?>
                                    </ol>
                                    <div class="d-grid mt-auto">
                                        <a type="button" class="btn btn-block btn-danger" href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $project['id']; ?>">View</a>
                                    </div>
                                </div>
                            </div>  
                    <?php endforeach; ?>
                </div>

                <div style="height:1000px;"></div>




            </div>
            <div class="tab-pane " id="profile-tab-pane" role="tabpanel" aria-labelledby="profile-tab" tabindex="0">
                <?php $comments = $db->run("SELECT * FROM comment LIMIT 0,100"); ?>
                <pre>
                    <?php print_r($comments); ?>
                </pre>
            </div>
            <div class="tab-pane " id="contact-tab-pane" role="tabpanel" aria-labelledby="contact-tab" tabindex="0">
                <?php $tasks = $db->run("SELECT * FROM task LIMIT 0,100"); ?>
                <pre>
                    <?php print_r($tasks); ?>
                </pre>
            </div>
            <div class="tab-pane " id="disabled-tab-pane" role="tabpanel" aria-labelledby="disabled-tab" tabindex="0">
                <?php $attachments = $db->run("SELECT * FROM attachment LIMIT 0,100"); ?>
                <pre>
                    <?php print_r($attachments); ?>
                </pre>
            </div>
        </div> 













        <div class="fixed-bottom d-md-none">
            <ul class="nav bg-body justify-content-between border-top flex-nowrap overflow-x-scroll px-2" id="myTab" role="tablist" style="/*background: rgba(0,0,0,0.90);*/">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home-tab-pane" type="button" role="tab" aria-controls="home-tab-pane" aria-selected="true">
                        <div class="vstack">
                        <i class="bi bi-house fs-2"></i>
                            <span class="small">Home</span>
                        </div>
                    </button>
                </li>

                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile-tab-pane" type="button" role="tab" aria-controls="profile-tab-pane" aria-selected="false">
                        <div class="vstack">
                        <i class="bi bi-calendar3 fs-2"></i>
                            <span class="small">Calendar</span>
                        </div>
                    </button>
                </li>

                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact-tab-pane" type="button" role="tab" aria-controls="contact-tab-pane" aria-selected="false">
                        <div class="vstack">
                        <i class="bi bi-list-task fs-2"></i>
                            <span class="small">Tasks</span>
                        </div>
                    </button>
                </li>

                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="disabled-tab" data-bs-toggle="tab" data-bs-target="#disabled-tab-pane" type="button" role="tab" aria-controls="disabled-tab-pane" aria-selected="false">
                        <div class="vstack">
                        <i class="bi bi-folder2-open fs-2"></i>
                            <span class="small">Files</span>
                        </div>
                    </button>
                </li>
            </ul> 
        </div>
    </div>

    <script src="<?php echo URL_ASSETS; ?>/js/bootstrap.bundle.min.js"></script>
        <!-- <script src="<?php echo URL_ASSETS; ?>/js/simple-lightbox.min.js"></script> -->
        <script src="<?php echo URL_ASSETS; ?>/js/jquery.js"></script>
        
        <!-- <script src="<?php echo URL_ASSETS; ?>/js/fullcalendar/dist/index.global.min.js"></script> -->
        <!-- <script src="<?php echo URL_ASSETS; ?>/js/autosize.min.js"></script> -->

        <script src="<?php echo URL_ASSETS; ?>/js/clients.js?t=<?php echo time(); ?>"></script>
        <!-- <script src="<?php echo URL_ASSETS; ?>/js/project.js?t=<?php echo time(); ?>"></script> -->

    </body>
</html>