<?php
if ( !$user['superAdmin'] ) {
    http_response_code(401);
    exit;
}

if ( !$name = $_GET['name'] ) {
    http_response_code(400);
    exit;
}

if ( !$user = $db->row("SELECT * FROM user WHERE name = ?", $name) ) {
    http_response_code(400);
    exit;
}

$numPerPage = 100;
$page       = ( isset($_GET['page']) ) 
    ? $_GET['page']
    : 1
;
$totalComments = $db->cell("SELECT COUNT(*) FROM comment WHERE (createdByName = ? AND userId IS NULL) OR (userId = ? AND createdByName IS NULL)", $name, $user['id']);
$numPages = ceil($totalComments / $numPerPage);
$offset = ($page * $numPerPage) - $numPerPage;
// $numPerPage = ( $page == $numPages )
//     ? $totalComments - (($page - 1) * $numPerPage)
//     : 100
// ;
// echo "page=$page, numPer=$numPerPage, totalComments=$totalComments, numPages=$numPages, offset=$offset";
$comments = $db->run("SELECT * FROM comment WHERE (createdByName = ? AND userId IS NULL) OR (userId = ? AND createdByName IS NULL) ORDER BY createdAt DESC LIMIT ?,?", $name, $user['id'], $offset, $numPerPage);
?>

<ul class="p-0">
<?php
foreach ( $comments as $comment ) :
    $type = ( $comment['createdByName'] )
        ? 'post'
        : 'reply'
    ;
    $checkId = ( $type === 'post' )
        ? $comment['id']
        : $comment['parentId']
    ;
    $project = $db->row("SELECT * FROM project WHERE id = ?", $comment['projectId']);
    $jumpTo = $db->cell("SELECT CEILING(COUNT(*) / 10) FROM comment WHERE sheetId = ? AND createdAt >= (SELECT createdAt FROM comment WHERE id = ? AND sheetId = ?) ORDER BY createdAt DESC", $project['sheetId'], $checkId, $project['sheetId']);
    if ( $jumpTo == 0 ) {
        $jumpTo = 1;
    }
    
?>
<a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $comment['projectId']; ?>&view=s&page=<?php echo $jumpTo; ?>#btb-<?php echo $type; ?>-<?php echo $comment['id']; ?>" class="dropdown-item">
    <li class="dropdown-item p-2">
        <div class="d-flex align-items-center">
<?php
        if ( !file_exists(PATH_ASSETS.'/images/avatar/'.$user['name'].'.jpg')) {
            $parts    = explode(' ', $user['name']);
            $initials = substr($parts[0], 0, 1) . substr(end($parts), 0, 1);
?>
            <div class="initial-avatar-notifications flex-shrink-0" alt="<?php echo $user['name']; ?>" title="<?php echo $user['name']; ?>"><?php echo $initials; ?></div>
<?php
        } else {
?>
            <img src="<?php echo URL_ASSETS; ?>/images/avatar/<?php echo $user['name']; ?>.jpg" alt="<?php echo $user['name']; ?>" title="<?php echo $user['name']; ?>" class="avatar-small" style="width:32px;height:32px;">
<?php 
        }
?>
            <div class="ms-2 w-100" style="min-width:0;">
                <span class="d-inline-block text-truncate w-100"><?php echo $comment['text']; ?></span>
                <div class="d-flex justify-content-between">
                    <span class="small text-muted lh-1"><?php echo ucfirst($type); ?> on <?php echo $project['title']; ?> Project</span>
                    <span class="small text-muted lh-1 ms-auto"><?php echo time_elapsed_string($comment['createdAt']); ?></span>
                </div>
            </div>
        </div>
    </li>
</a>
<hr class="my-1">
<?php endforeach; ?>
</ul>
<nav class="mb-2">
    <ul class="pagination mb-0">
        <li class="page-item <?php if ( $page == 1 ) : ?>disabled<?php endif; ?>">
            <!-- <a class="page-link text-danger paginationItem" href="<?php echo URL_APP_ADMIN; ?>/project/?projectId=<?php echo $pid; ?>&view=<?php echo $view; ?>&page=1">
                <span aria-hidden="true">&laquo;</span>
            </a> -->
            <button class="page-link text-danger paginationItem" data-name="<?php echo $name; ?>" data-page="1">
                <span aria-hidden="true">&laquo;</span>
            </button>
        </li>
        <li class="page-item text-danger <?php if ( $page == 1 ) : ?>disabled<?php endif; ?>">
            <!-- <a class="page-link text-danger paginationItem" href="<?php echo URL_APP_ADMIN; ?>/project/?projectId=<?php echo $pid; ?>&view=<?php echo $view; ?>&page=<?php echo $page - 1; ?>">
                <span aria-hidden="true">&lsaquo;</span>
            </a> -->
            <button class="page-link text-danger paginationItem" data-name="<?php echo $name; ?>" data-page="<?php echo $page - 1; ?>">
                <span aria-hidden="true">&lsaquo;</span>
            </button>
        </li>
<?php 
            for ( $c = ($page - 2); $c <= ($page + 2); $c++ ) :
                if ( $c < 1 || $c > $numPages ) {
                    continue;
                }
?>
            <li class="page-item <?php if ( $page == $c ) : ?>active<?php endif; ?>">
                <!-- <a class="page-link text-danger paginationItem" href="<?php echo URL_APP_ADMIN; ?>/project/?projectId=<?php echo $pid; ?>&view=<?php echo $view; ?>&page=<?php echo $c; ?>"><?php echo $c; ?></a> -->
                <button class="page-link text-danger paginationItem" data-name="<?php echo $name; ?>" data-page="<?php echo $c; ?>">
                    <?php echo $c; ?>
                </button>
            </li>
        <?php endfor; ?>
        <li class="page-item <?php if ( $page == $numPages ) : ?>disabled<?php endif; ?>">
            <!-- <a class="page-link text-danger paginationItem" href="<?php echo URL_APP_ADMIN; ?>/project/?projectId=<?php echo $pid; ?>&view=<?php echo $view; ?>&page=<?php echo $page + 1; ?>">
                <span aria-hidden="true">&rsaquo;</span>
            </a> -->
            <button class="page-link text-danger paginationItem" data-name="<?php echo $name; ?>" data-page="<?php echo $page + 1; ?>">
                <span aria-hidden="true">&rsaquo;</span>
            </button>
        </li>
        <li class="page-item <?php if ( $page == $numPages ) : ?>disabled<?php endif; ?>">
            <!-- <a class="page-link text-danger paginationItem" href="<?php echo URL_APP_ADMIN; ?>/project/?projectId=<?php echo $pid; ?>&view=<?php echo $view; ?>&page=<?php echo $numPages; ?>">
                <span aria-hidden="true">&raquo;</span>
            </a> -->
            <button class="page-link text-danger paginationItem" data-name="<?php echo $name; ?>" data-page="<?php echo $numPages; ?>">
                <span aria-hidden="true">&raquo;</span>
            </button>
        </li>
    </ul>
</nav>
