<?php
if ( !$user['superAdmin'] ) {
    http_response_code(401);
    exit;
}

if ( !$title = $_GET['projectTitle'] ) {
    http_response_code(400);
    exit;
}

if ( !$project = $db->row("SELECT * FROM project WHERE title = ?", $title) ) {
    http_response_code(400);
    exit;
}

$root = $db->cell("SELECT rowId FROM task WHERE projectId = ? AND root = 1", $project['id']);
$cats = $db->run("SELECT * FROM task WHERE projectId = ? AND parentId = ?", $project['id'], $root);

$categories = [];
foreach ( $cats as $cat ) {
    $categories[$cat['rowId']] = $cat['title'];
}
// echo "<pre>";
// print_r($categories);
// echo "</pre>";

$tasks = [];
$statuses = [];
$array = $db->run("SELECT DISTINCT status FROM task WHERE projectId = ? AND (status > '' OR status IS NULL) AND status != 'Daily Log'", $project['id']);
foreach ( $array as $element ) {
    foreach ( $element as $key => $value ) {
        $statuses[] = $value;
    }
}
// echo "<pre>";
// print_r($statuses);
// echo "</pre>";
// exit;

$totalTasks = 0;
foreach ( $statuses as $status ) {
// echo "<br>$status";
    $tasks[$status] = $db->run("SELECT * FROM task WHERE projectId = ? AND status = ? ORDER BY rowNumber ASC", $project['id'], $status);
    $totalTasks += count($tasks[$status]);
// echo "<br>$totalTasks";
}
$totalTasks = $totalTasks - count($categories);
?>

<ul class="nav nav-tabs border-bottom-0 flex-nowrap overflow-x-scroll overflow-y-hidden align-items-center" id="tablist" role="tablist">
    <?php
        $i = 0; 
        foreach ( $statuses as $status ) :
            $statusString = str_replace(' ', '-', $status);
            // $totalTasks = count($tasks) - count($categories);
            $pct = abs(count($tasks[$status]) / $totalTasks * 100);
            $pct = round($pct, 1);

            switch ( $status ) {
                case 'N/A' :
                    $class = "text-bg-secondary";
                    break;
                case 'Not Started' :
                    $class = "text-bg-danger";
                    break;
                case 'Negotiating' :
                    $class = "text-bg-primary";
                    break;
                case 'Scheduled' :
                    $class = "text-bg-info";
                    break;
                case 'In Progress' :
                    $class = "text-bg-warning";
                    break;
                case 'Completed' :
                    $class = "text-bg-success";
                    break;
            }
    ?>
    <li class="nav-item" role="presentation">
        <button class="nav-link <?php if ( $i == 0 ) : ?>active<?php endif; ?>" id="<?php echo $statusString; ?>-tab" data-bs-toggle="tab" data-bs-target="#<?php echo $statusString; ?>-tab-pane" type="button" role="tab" aria-controls="<?php echo $statusString; ?>-tab-pane" <?php if ( $i == 0 ) : ?>aria-selected="true"<?php endif; ?>>
            <span class="badge rounded-pill <?php echo $class; ?> text-end py-2"><?php echo $status; ?> (<?php echo count($tasks[$status]); ?> - <?php echo $pct; ?>%)</span>
        </button>
    </li>
    <?php 
            $i++;
        endforeach; 
    ?>
    <li class="nav-item text-muted text-nowrap ms-auto">(# tasks - % complete)</li>
</ul>
<div class="tab-content" id="tabcontent">
    <?php 
        $i = 0;
        foreach ( $statuses as $status ) :
            $statusString = str_replace(' ', '-', $status);
    ?>
    <div class="tab-pane fade <?php if ( $i == 0 ) : ?>show active<?php endif ?>" id="<?php echo $statusString; ?>-tab-pane" role="tabpanel" aria-labelledby="<?php echo $statusString; ?>-tab" tabindex="0">
        <ul class="list-group">
        <?php 
            foreach ( $tasks[$status] as $task ) : 
                if ( $task['parentId'] == $root ) {
                    continue;
                }
        ?>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <div class="fw-bold flex-nowrap text-truncate"><?php echo $task['title']; ?></div>
                <div class="small text-muted flex-nowrap text-truncate"><?php echo $categories[$task['parentId']]; ?></div>
            </li>
        <?php endforeach; ?>
        </ul>
    </div>
    <?php 
            $i++;
        endforeach;
    ?>
</div>