/*! @rat.md/bs-lightbox | @version 1.1.0 | @license MIT | @copyright rat.md <info@rat.md> */
class t{static get NAME(){return"lightbox"}static get VERSION(){return"1.1.0"}static get DEFAULTS(){return{carousel:{id:null,controls:!0,indicators:!1,interval:5e3,keyboard:!0,pause:"hover",ride:!1,touch:!0,wrap:!0},lightbox:{loader:!1,replacePictures:!1},modal:{id:null,backdrop:!0,focus:!0,keyboard:!0,size:"xl"}}}static get $(){let e=t._jquery||window.$||window.jQuery;if(!e)throw new Error("No jQuery object found, please use Lightbox.$ = <jQuery>.");return e}static set $(e){t._jquery=e}static get CAROUSEL(){let e=t._carousel||(window.bootstrap||window.Bootstrap||{}).Carousel;if(!e)throw new Error("No Bootstrap Carousel prototype found, please use Lightbox.CAROUSEL = <Bootstrap.Carousel>.");return e}static set CAROUSEL(e){t._carousel=e}static get MODAL(){let e=t._modal||(window.bootstrap||window.Bootstrap||{}).Modal;if(!e)throw new Error("No Bootstrap Modal prototype found, please use Lightbox.MODAL = <Bootstrap.Modal>.");return e}static set MODAL(e){t._modal=e}static get SELECTOR(){return'[data-toggle="lightbox"],[data-bs-toggle="lightbox"],[data-rat-lightbox]'}static invoke(t=null,e={}){return t="string"!=typeof t?this.SELECTOR:t,Array.from(document.querySelectorAll(t),(t=>this.getOrCreateInstance(t,e)))}static hasInstance(t){if("string"==typeof t)return this.instances.has(t);{let e=t.hasAttribute("data-bs-gallery")?t.dataset.bsGallery:t;return this.instances.has(e)}}static getInstance(t){if("string"==typeof t)return this.instances.has(t)?this.instances.get(t):null;{let e=t.dataset.bsGallery||t.dataset.gallery||t;return this.instances.has(e)?this.instances.get(e):null}}static getOrCreateInstance(t,e={}){let s=this.getInstance(t);return null===s?s=new this(t,e):s.append(t),s}constructor(e,s={}){this.items=new Map,this.events=new Map;let i=e.dataset.bsGallery||e.dataset.gallery||e;if(t.instances.has(i))throw new Error("An instance with the passed element or gallery has already been created.");t.instances.set(i,this),this.legacy="4"===t.CAROUSEL.VERSION[0];let a=t.DEFAULTS;this.config={carousel:Object.assign({},a.carousel,s.carousel||{}),lightbox:Object.assign({},a.lightbox,s.lightbox||{}),modal:Object.assign({},a.modal,s.modal||{})},this.append(e),this.onKeyUpListener=this._onKeyUp.bind(this)}_onKeyUp(t){"ArrowRight"===t.key?this.next():"ArrowLeft"===t.key&&this.prev()}_createLightbox(){let t="";this.config.carousel.controls&&this.items.size>1&&(t=`\n                <button class="carousel-control-prev" type="button" data-${this.legacy?"":"bs-"}target="#${this.config.carousel.id||"lightboxCarousel"}" data-${this.legacy?"":"bs-"}slide="prev">\n                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>\n                    <span class="${this.legacy?"sr-only":"visually-hidden"}">Previous</span>\n                </button>\n                <button class="carousel-control-next" type="button" data-${this.legacy?"":"bs-"}target="#${this.config.carousel.id||"lightboxCarousel"}" data-${this.legacy?"":"bs-"}slide="next">\n                    <span class="carousel-control-next-icon" aria-hidden="true"></span>\n                    <span class="${this.legacy?"sr-only":"visually-hidden"}">Next</span>\n                </button>\n            `);let e="";this.config.carousel.indicators&&this.items.size>1&&(e=`\n                <div class="carousel-indicators">\n                    ${[...Array(this.items.size)].map(((t,e)=>`<button type="button" data-${this.legacy?"":"bs-"}target="#${this.config.carousel.id||"lightboxCarousel"}" data-${this.legacy?"":"bs-"}slide-to="${e}" class="${0===e?"active":""}" aria-current="${0===e?"true":"false"}"></button>`)).join("\n")}\n                </div>\n            `);let s=document.createElement("DIV");s.className="modal modal-lightbox fade",s.tabIndex=-1,s.innerHTML=`\n            <div id="${this.config.modal.id||"lightboxModal"}" class="modal-dialog${null!==this.config.modal.size?" modal-"+this.config.modal.size:" "} modal-dialog-centered">\n                <div class="modal-content">\n                    <div class="modal-body p-0">\n                        <div id="${this.config.carousel.id||"lightboxCarousel"}" class="carousel carousel-fade slide">\n                            ${e}\n\n                            <div class="carousel-inner">\n                                ${Array.from(this.items.values()).map(((t,e)=>{let s=t.image instanceof HTMLImageElement?t.image.src:t.image.querySelector("img").src;return`\n                                        <div class="carousel-item${0===e?" active":""}">\n                                            ${this.config.lightbox.loader?`\n                                                <div class="${this.legacy?"embed-responsive embed-responsive-16by9":"ratio ratio-16x9"}" data-img-src="${s}">\n                                                    <div class="d-flex justify-content-center align-items-center embed-responsive-item">\n                                                        <div class="spinner-border" role="status">\n                                                            <span class="${this.legacy?"sr-only":"visually-hidden"}">Loading...</span>\n                                                        </div>\n                                                    </div>\n                                                </div>\n                                            `:`\n                                                ${t.image.outerHTML}\n                                            `}\n                                            \n                                            ${t.caption||t.title?`\n                                                <div class="carousel-caption d-none d-md-block">\n                                                    ${t.title?`<div class="h5">${t.title}</div>`:""}\n                                                    ${t.caption?`<p>${t.caption}</p>`:""}\n                                                </div>\n                                            `:""}\n                                        </div>\n                                    `})).join("\n")}\n                            </div>\n\n                            ${t}\n                        </div>\n                    </div>\n                </div>\n            </div>\n        `,this.lightbox=s}_createModal(){if(null!==this.lightbox)if(this.legacy){let e=Object.assign({},this.config.modal,{show:!1});this.modal=t.$(this.lightbox).modal(e)}else this.modal=t.MODAL.getOrCreateInstance(this.lightbox,this.config.modal)}_createCarousel(){if(null!==this.lightbox)if(this.legacy){let e=Object.assign({},this.config.carousel);e.ride||(e.interval=!1),this.carousel=t.$(this.lightbox.querySelector(".carousel")).carousel(e)}else this.carousel=t.CAROUSEL.getOrCreateInstance(this.lightbox.querySelector(".carousel"),this.config.carousel)}dispose(){return document.removeEventListener("keyup",this.onKeyUpListener),this.carousel&&(this.legacy?this.carousel.carousel("dispose"):this.carousel.dispose(),this.carousel=null),this.modal&&(this.legacy?this.modal.modal("dispose"):this.modal.dispose(),this.modal=null),this.lightbox&&this.lightbox.parentElement&&this.lightbox.remove(),this.lightbox=null,this}_getImage(t){if(t instanceof HTMLImageElement||t instanceof HTMLPictureElement)return t;return t.querySelector("picture,img")}_getTitle(t,e){let s=t.dataset.bsTitle||t.dataset.title||t.title||null;return s||t===e||(s=e.dataset.bsTitle||e.dataset.title||null),s}_getCaption(t,e){if("FIGURE"!==t.tagName.toUpperCase()){let s=t.dataset.bsCaption||t.dataset.caption||null;return s||(s=e.dataset.bsCaption||e.dataset.caption||null),s}{let e=t.querySelector("FIGCAPTION");if(e&&e.innerText.trim().length>0)return e.innerText.trim()}}append(t){if(this.items.has(t))return this;let e=this._getImage(t);if(null===e)throw new Error(`The passed element is not nor contains a supported image source. Element HTML: ${t.outerHTML}.`);let s=e.cloneNode(!0);return s.className="w-100",t instanceof HTMLAnchorElement&&t.href.length>0&&(s instanceof HTMLImageElement?s.src=t.href:s instanceof HTMLPictureElement&&this.config.lightbox.replacePictures&&(s.querySelector("img").src=t.href,Array.from(s.querySelectorAll("source"),(t=>t.remove())))),this.items.set(t,{source:t,image:s,title:this._getTitle(t,s),caption:this._getCaption(t,s)}),t.setAttribute(this.legacy?"data-slide-to":"data-bs-slide-to",(this.items.size-1).toString()),t.addEventListener("click",(e=>{e.preventDefault(),this.show(t)})),this}toggle(){return this.lightbox?this.hide():this.show()}show(t=null){if(this.lightbox)return this;if(this._createLightbox(),this._createModal(),this._createCarousel(),this.legacy){let t=["slid.bs.carousel","slide.bs.carousel","hide.bs.modal","hidden.bs.modal","hidePrevented.bs.modal","show.bs.modal","shown.bs.modal"];for(let e of t)(e.endsWith("modal")?this.modal:this.carousel).on(e,(t=>{(e.endsWith("modal")?this.lightbox:this.lightbox.querySelector(".carousel")).dispatchEvent(new Event(e,{bubbles:t.bubbles,cancelable:t.cancelable,composed:t.composed}))}))}t instanceof HTMLElement&&(t.dataset.bsSlideTo||t.dataset.slideTo)&&this.lightbox.addEventListener("show.bs.modal",(e=>{let s=parseInt(t.dataset.bsSlideTo||t.dataset.slideTo,10);this.legacy?this.carousel.carousel(s):this.carousel.to(s)})),this.config.lightbox.loader&&this.lightbox.addEventListener("show.bs.modal",(t=>{Array.from(this.lightbox.querySelectorAll("[data-img-src]"),(t=>{let e=document.createElement("IMG");e.className="w-100",e.onload=s=>{t.replaceWith(e)},e.src=t.dataset.imgSrc}))}));let e=this.lightbox.querySelector(".carousel");for(let[t,s]of this.events.entries())t.endsWith("modal")&&s.forEach((e=>this.lightbox.addEventListener(t,e))),t.endsWith("carousel")&&s.forEach((s=>e.addEventListener(t,s)));return this.config.carousel.keyboard&&document.addEventListener("keyup",this.onKeyUpListener),this.lightbox.addEventListener("hidden.bs.modal",this.dispose.bind(this)),this.legacy?this.modal.modal("show"):this.modal.show(),this}hide(){return this.modal&&(this.legacy?this.modal.modal("hide"):this.modal.hide()),this}cycle(){return this.carousel&&(this.legacy?this.carousel.carousel("cycle"):this.carousel.cycle()),this}next(){return this.carousel&&(this.legacy?this.carousel.carousel("next"):this.carousel.next()),this}prev(){return this.carousel&&(this.legacy?this.carousel.carousel("prev"):this.carousel.prev()),this}to(t){return this.carousel?("prev"===t||"previous"===t?this.prev():"next"===t?this.next():this.legacy?this.carousel.carousel(t):this.carousel.to(t),this):this}on(t,e){return this.events.has(t)||this.events.set(t,new Set),this.events.get(t).add(e),this}off(t,e){return this.events.has(t)&&this.events.get(t).delete(e),this.lightbox&&t.endsWith("modal")&&this.lightbox.removeEventListener(t,e),this.lightbox&&t.endsWith("carousel")&&this.lightbox.querySelector(".carousel").removeEventListener(t,e),this}}t._jquery=null,t._carousel=null,t._modal=null,t.instances=new Map;export{t as default};//# sourceMappingURL=rat.lightbox.min.js.map
