<?php 
    //projectId needs to be set, or we can't load
    if ( !isset($_GET['projectId']) ) {
        session_start();
        $_SESSION['error'] = 'No project ID';

        header('Location: '.URL_APP.'/dashboard');
        exit;
    } 

    $pid = $_GET['projectId'];
    
    //check if user is an admin. if not, check if they are assigned to this project
    if ( !$user['admin'] ) {
        if ( !$exists = $db->cell("SELECT id FROM client_project WHERE clientId = ? AND projectId = ?", $user['client']['id'], $pid) ) {
            session_start();
            $_SESSION['error'] = "You don't have permission to view that project";

            header('Location: '.URL_APP.'/dashboard');
            exit;
        }
    } else {
        //load all projects for admins
        include 'src/admin-load-projects.php';
    }

    $userProject = $db->row("SELECT * FROM project WHERE id = ?", $pid);
    $userLikes   = array_column($db->run("SELECT thumb.commentId FROM thumb WHERE thumb.userId = ?", $user['id']), 'commentId');

    include 'src/load-calendar-events.php';
    include 'src/load-comments.php';
    // include 'src/load-images.php';
    include 'src/load-tasks.php';
    include 'src/load-plans.php';
    include 'src/load-models.php';
    
    session_start();
    if ( isset($_SESSION['error']) ) {
        $error = $_SESSION['error'];
        unset($_SESSION['error']);
    } else {
        $error = false;
    }

    $detect  = new Mobile_Detect;
    $page    = $_GET['page'] ?? 1;
    $view    = $_GET['view'] ?? $_COOKIE['btbView'] ?? 's';
    $allowed = ( $user['admin'] )
        ? 1
        : $db->cell("SELECT social FROM client WHERE userId = ?", $user['id'])
    ;

    setcookie('btbView', $view, time() + (60*60*24*30*12), '/clients', URL_COOKIES);

    include 'layout/header.php';
?>

<style>
</style>

<?php include 'template/toolbar.php'; ?>
    
<?php if ( $error ) : ?>
    <div class="container-fluid container-lg mt-5">
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <?php echo $error; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
<?php endif; ?>

<?php
    if ( $view == 's' && $allowed ) {
        //social templates
        include 'template/index-social.php';
    } else {
        include 'template/calendar.php';
        include 'template/tasks.php';
        include 'template/forecast-container.php';
        include 'template/team.php';
    }
?>

<?php include 'template/offcanvas-daily-log.php'; ?>
<?php // include 'template/offcanvas-files.php'; ?>
<?php include 'template/offcanvas-plans.php'; ?>
<?php include 'template/offcanvas-models.php'; ?>

<div class="d-none" id="events">
    <?php echo json_encode($events); ?>
</div>
<div class="d-none" id="isMobile">
    <?php 
        if ( $detect->isMobile() ) {
            echo 1;
        } else {
            echo 0;
        }
    ?>
</div>
<div class="d-none" id="isTablet">
    <?php 
        if ( $detect->isTablet() ) {
            echo 1;
        } else {
            echo 0;
        }
    ?>
</div>
<input id="projectId" type="hidden" value="<?php echo $userProject['id']; ?>">
<input id="userId" type="hidden" value="<?php echo $user['id']; ?>">
<input id="city" type="hidden" value="<?php echo $userProject['city']; ?>">
<input id="zip" type="hidden" value="<?php echo $userProject['zip']; ?>">
<input id="view" type="hidden" value="<?php echo $view; ?>">

<?php
    if ( $user['admin'] ) {
        include 'template/create-modal.php';
    }
    include 'template/contact-modal.php';
    include 'layout/footer.php';