<?php

    $name = ( $user['name'] )
        ? $user['name']
        : $user['email']
    ;

    $oCommentText = $db->cell("SELECT text FROM comment WHERE id = ?", $commentId);
    $proj         = $db->row("SELECT * FROM project WHERE id = ?", $projectId);

    //project email notifications
    $pdo           = $db->getPdo();
    $stmt          = $pdo->prepare("SELECT user.email, user.name, user.superAdmin FROM user, project_email_notification WHERE (project_email_notification.projectId = ? AND project_email_notification.userId = user.id) OR user.superAdmin = 1 ORDER BY user.name ASC;");
    $exec          = $stmt->execute([$projectId]);
    $notifications = $stmt->fetchAll(\PDO::FETCH_ASSOC);

    try {
        $dMessageTransport = (new Swift_SmtpTransport(EMAIL_SMTP, 587));
        $dMessageMailer    = new Swift_Mailer($dMessageTransport);
        $dMessageSubject   = COMPANY_ABBR." Client Portal - $name replied to a comment";
        $dMessage          = (new Swift_Message($dMessageSubject));

        // $dTo[EMAIL_ADMIN_ADDRESS] = EMAIL_ADMIN_NAME;
        foreach ( $notifications as $notification ) {
            $dTo[$notification['email']] = $notification['name'];
        }

        ob_start();
?>
            <h3><?php echo $name; ?> Replied to a Comment</h3>
            <p>Time: <?php echo date('Y-m-d H:i:s', time()); ?></p>
            <p>Email: <?php echo $user['email']; ?></p>
            <p>Project: <?php echo $proj['title']; ?></p>
            <p>Reply Text: <?php echo nl2br(htmlspecialchars($text)); ?></p>
            <p>Original Comment Text: <?php echo nl2br(htmlspecialchars($oCommentText)); ?></p>
            <p><a href="<?php echo URL_APP; ?>/project/?projectId=<?php echo $projectId; ?>&view=s">Go to Project</a></p>
<?php
        $dMessageHtml = ob_get_clean();

        $dMessage->setFrom([EMAIL_FROM_ADDRESS => EMAIL_FROM_NAME])
            ->setTo($dTo)
            ->setBody($dMessageHtml, 'text/html')
        ;

        $dMessageResult = $dMessageMailer->send($dMessage);
    } catch ( Exception $e ) {
        //log it, notify
    }
?>