<div class="offcanvas offcanvas-end" tabindex="-1" id="imageDrawer" aria-labelledby="imageDrawerLabel">
    <div class="offcanvas-header border-bottom shadow-sm" id="imageDrawerHeader" style="flex-wrap:wrap;">
        <h3 class="offcanvas-title" id="imageDrawerLabel">Files</h3>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body" id="imageContainer">
        <?php 
            foreach ( $images as $image ) : 
                switch ( $image['mimeType'] ) :
                    case 'image/jpeg' :
                    case 'image/png' :
                        $baseSrc  = URL_ATTACHMENTS;
                        $basePath = PATH_ATTACHMENTS;

                        $link = "$baseSrc/$image[pathname]";
                        $src  =  $link;
                        if ( file_exists("$basePath/small/$image[pathname]") ) {
                            $src  = "$baseSrc/small/$image[pathname]";
                        }
        ?>
                        <a href="<?php echo $link; ?>" target="_blank">
                            <img 
                                data-src="<?php echo $src; ?>" 
                                alt="<?php echo $userProject['title'] ?>" 
                                class="img-fluid img-thumbnail lazy mb-3"
                            >
                        </a>
        <?php
                        break;
                    case 'application/pdf' :
        ?>
                        <div class="col text-center border rounded mb-3">
                            <a href="<?php echo URL_ATTACHMENTS; ?>/<?php echo $image['pathname']; ?>" target="_blank"><small><?php echo $image['name']; ?></small></a>
                            <br>
                            <a href="<?php echo URL_ATTACHMENTS; ?>/<?php echo $image['pathname']; ?>" target="_blank"><img src="<?php echo URL_ASSETS; ?>/images/pdf-icon.png" class="img-fluid"></a>
                            <br>
                            <a href="<?php echo URL_ATTACHMENTS; ?>/<?php echo $image['pathname']; ?>" target="_blank">View PDF</a>
                        </div>
        <?php
                        break;
                    case 'video/quicktime' :
                    case 'video/mp4' :
        ?>
                        <video width="100%" controls class="img-thumbnail">
                            <source src="<?php echo URL_ATTACHMENTS; ?>/<?php echo $image['pathname']; ?>" type="video/mp4">
                        </video>
        <?php
                    break;
                endswitch;
            endforeach; 
        ?>
    </div>
</div>