<div class="container-fluid px-0 mb-5">
    <div class="border-top border-bottom" style="background-color: var(--bs-tertiary-bg);">
        <div class="d-flex justify-content-between">
            <h3 class="p-3 m-0">Project Task List</h3>
            <!-- <button class="btn btn-link text-danger taskListToggle pe-3 btbAction" data-action="click" data-target="task list toggle" data-bs-toggle="collapse" data-bs-target="#taskList" onclick="this.textContent = ( this.textContent == 'Collapse' ) ? 'Expand' : 'Collapse';">Expand</button> -->
            <button class="btn btn-link text-danger taskListToggle pe-3 btbAction" data-action="click" data-target="task list toggle" data-bs-toggle="collapse" data-bs-target="#taskList">Expand</button>
            <!-- <button id="taskListToggle" class="btn btn-link text-danger pe-3 btbAction" data-action="click" data-target="task list toggle" data-bs-toggle="collapse" data-bs-target="#taskList">Expand</button> -->
        </div>
    </div>
    <div id="taskList" class="collapse hide border-bottom">
        <ul class="list-group list-group-flush">
            <?php
            $root = false;
            foreach ( $tasks as $task ) :
                $showStatus = true;
                if ( !$root ) {
                    if ( $task['root'] ) {
                        $root = $task['rowId'];
                    }
                }
                if ( 
                    !$task['title'] || 
                    strtolower($task['title']) == 'enter additional items' || 
                    strtolower($task['title']) == 'daily log' || 
                    str_contains(strtolower($task['title']), 'task list')
                ) {
                    continue;
                }
            ?>
                <!-- <div class="d-flex justify-content-between"> -->
                    <li id="btb-task-<?php echo $task['id']; ?>" class="list-group-item d-flex justify-content-between <?php if ( $task['parentId'] == $root ) : $showStatus = false; ?>sticky-top text-light-emphasis bg-secondary-subtle fw-bold border-bottom border-danger-subtle<?php endif; ?>" title="<?php echo $task['title']; ?>">
                        <span class="d-inline-block text-truncate"><?php echo $task['title']; ?></span>
                        <?php
                            if ( $showStatus ) :
                                switch ( $task['status'] ) {
                                    case 'N/A' :
                                        $class = "text-bg-secondary";
                                        break;
                                    case 'Not Started' :
                                        $class = "text-bg-danger";
                                        break;
                                    case 'Negotiating' :
                                        $class = "text-bg-primary";
                                        break;
                                    case 'Scheduled' :
                                        $class = "text-bg-info";
                                        break;
                                    case 'In Progress' :
                                        $class = "text-bg-warning";
                                        break;
                                    case 'Completed' :
                                        $class = "text-bg-success";
                                        break;
                                }
                        ?>
                            <span class="badge rounded-pill <?php echo $class; ?> text-end py-2"><?php echo $task['status']; ?></span>
                        <?php
                            endif;
                        ?>
                        <?php if ( $task['parentId'] == $root ) : ?>
                            <span class="btn btn-link text-danger ms-auto p-0 taskListToggle btbAction" data-action="click" data-target="task list toggle" data-bs-toggle="collapse" data-bs-target="#taskList">Collapse</span>
                        <?php endif; ?>
                    </li>
                <!-- </div> -->
            <?php
            endforeach;
            ?>
        </ul>
    </div>
</div>